<?php
/**
 * Template for displaying the details of verified user.
 */
defined( 'ABSPATH' ) || exit;

?>

<!DOCTYPE html>
<html lang="en" <?php echo( is_rtl() ? 'dir="rtl"' : '' ); ?> >
	<head>
		<meta charset="UTF-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		<title><?php the_title(); ?></title>
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?> translate="no">
	<div class="masteriyo-qr-certificate">
		<div class="masteriyo-qr-certificate--wrapper">
			<div class="masteriyo-qr-certificate__avatar">
				<img src="<?php echo esc_url( $student->profile_image_url() ); ?>"  alt="student image" />
			</div>

			<div class="masteriyo-qr-certificate__desc">
				<div class="masteriyo-qr-certificate__desc--content">
					<label for="first_name"><?php echo esc_html__( 'First Name', 'learning-management-system' ); ?>:</label>
					<p><?php echo esc_attr( $student->get_first_name() ); ?></p>
				</div>

				<div class="masteriyo-qr-certificate__desc--content">
					<label for="first_name"><?php echo esc_html__( 'Last Name', 'learning-management-system' ); ?>:</label>
					<p><?php echo esc_attr( $student->get_last_name() ); ?></p>
				</div>

				<div class="masteriyo-qr-certificate__desc--content">
					<label for="first_name"><?php echo esc_html__( 'Username', 'learning-management-system' ); ?>:</label>
					<p><?php echo esc_attr( $student->get_username() ); ?></p>
				</div>

				<div class="masteriyo-qr-certificate__desc--content">
					<label for="first_name"><?php echo esc_html__( 'Instructor Name', 'learning-management-system' ); ?>:</label>
					<p><?php echo esc_attr( $instructor->get_username() ); ?></p>
				</div>

				<div class="masteriyo-qr-certificate__desc--content">
					<label for="first_name"><?php echo esc_html__( 'Name of Course', 'learning-management-system' ); ?>:</label>
					<p><?php echo esc_attr( $course->get_name() ); ?></p>
				</div>

				<div class="masteriyo-qr-certificate__desc--content">
					<label for="first_name"><?php echo esc_html__( 'Certificate Code', 'learning-management-system' ); ?>:</label>
					<p><?php echo esc_attr( $verification_id ); ?></p>
				</div>

				<div class="masteriyo-qr-certificate__desc--content">
					<label for="first_name"><?php echo esc_html__( 'Course Completion Date', 'learning-management-system' ); ?>:</label>
					<p><?php echo esc_attr( $completed_at ); ?></p>
				</div>
			</div>
		</div>
	</div>

	<?php wp_footer(); ?>
	</body>
</html>

<?php
