<?php
/**
 * Addon Name: HubSpot Integration
 * Addon URI: https://masteriyo.com/wordpress-lms/
 * Description: Seamlessly integrate HubSpot with Masteriyo LMS for efficient and automated email marketing within your learning management system.
 * Author: Masteriyo
 * Addon Type: integration
 * Author URI: https://masteriyo.com
 * Plan: Starter
 */

use Masteriyo\Addons\HubSpotIntegration\HubSpotIntegrationAddon;
use Masteriyo\Pro\Addons;

define( 'MASTERIYO_HUBSPOT_INTEGRATION_FILE', __FILE__ );
define( 'MASTERIYO_HUBSPOT_INTEGRATION_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_HUBSPOT_INTEGRATION_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_HUBSPOT_INTEGRATION_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_HUBSPOT_INTEGRATION_SLUG', 'hubspot-integration' );
define( 'MASTERIYO_HUBSPOT_INTEGRATION_BASE_URL', 'https://api.hubapi.com/' );

// Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_HUBSPOT_INTEGRATION_SLUG ) ) {
	return;
}

// Initiate HubSpot Integration addon.
HubSpotIntegrationAddon::instance()->init();
