<?php
/**
 * The template for displaying the prerequisites section in single course page.
 */

use Masteriyo\Enums\CourseProgressStatus;
?>
<div class="masteriyo-single-course--prerequisites">
	<div class="masteriyo-prerequisites--msg">
		<div class="masteriyo-alert masteriyo-warning-msg">
			<span>
				<?php esc_html_e( 'NOTE: You have to complete the following courses before you can enroll this course.', 'learning-management-system' ); ?>
			</span>
		</div>
	</div>

	<div class="masteriyo-prerequisites--list">
		<ul>
		<?php foreach ( $prerequisites as $prerequisite ) : ?>
			<li>
			<?php if ( CourseProgressStatus::COMPLETED === $prerequisite['status'] ) : ?>
				<span class="dashicons dashicons-yes"></span>
			<?php else : ?>
				<span class="dashicons dashicons-no"></span>
			<?php endif; ?>
				<a target="_blank" href="<?php echo esc_url( $prerequisite['permalink'] ); ?>">
					<?php echo esc_html( $prerequisite['name'] ); ?>
				</a>
			</li>
		<?php endforeach; ?>
		</ul >
	</div>
</div>
<?php
