<?php
/**
 * Template hooks and their corresponding functions.
 *
 * @since 2.6.8
 *
 * @package Masteriyo\Addons\PublicProfile
 */

use Masteriyo\Constants;
use Masteriyo\Roles;

if ( ! function_exists( 'add_action' ) || ! function_exists( 'add_filter' ) ) {
	return;
}

// Public profile page left sides.
add_action( 'masteriyo_public_profile_left_main_content', 'masteriyo_public_profile_info', 10 );
add_action( 'masteriyo_public_profile_left_main_content', 'masteriyo_public_profile_about', 15 );
add_action( 'masteriyo_public_profile_left_main_content', 'masteriyo_public_profile_links', 20 );
add_action( 'masteriyo_public_profile_left_main_content', 'masteriyo_public_profile_joined', 25 );

// Public profile page right side topbar.
add_action( 'masteriyo_public_profile_right_main_content', 'masteriyo_public_profile_topbar', 10 );

// Overview section.
add_action( 'masteriyo_public_profile_overview_main_content', 'masteriyo_public_profile_overview_cards', 15 );
add_action( 'masteriyo_public_profile_overview_main_content', 'masteriyo_public_profile_overview_courses', 20 );
add_action( 'masteriyo_public_profile_overview_main_content', 'masteriyo_public_profile_overview_enrolled_courses', 25 );

// Courses offered section.
add_action( 'masteriyo_public_profile_courses_offered_main_content', 'masteriyo_public_profile_courses_offered_content', 10 );
add_action( 'masteriyo_after_public_profile_courses_offered_content', 'masteriyo_public_profile_overview_courses_offered_pagination', 10, 2 );

// Enrolled courses section.
add_action( 'masteriyo_public_profile_enrolled_courses_main_content', 'masteriyo_public_profile_enrolled_courses', 10 );
add_action( 'masteriyo_public_profile_enrolled_courses_content', 'masteriyo_public_profile_overview_enrolled_courses_gridcard', 10, 2 );
add_action( 'masteriyo_after_public_profile_enrolled_courses_content', 'masteriyo_public_profile_overview_enrolled_courses_pagination', 10, 2 );

// Certificates section.
add_action( 'masteriyo_public_profile_certificates_main_content', 'masteriyo_public_profile_certificates_content', 10 );
