<?php

/**
 * The Template for displaying info section of overview tab in the public profile page.
 *
 * @since 2.6.8
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering info section in public profile page.
 *
 * @since 2.6.8
 */
do_action( 'masteriyo_before_public_profile_info' );

?>
<div class="masteriyo-col-left--info">
	<figure class="masteriyo-user--profile-pic">
		<img src="<?php echo esc_url_raw( $data['user_profile']['avatar_url'] ); ?>" alt="">
	</figure>

	<h2 class="masteriyo-user--name"><?php echo esc_html( $data['user_profile']['full_name'] ); ?></h2>

	<p class="masteriyo-user--username"><?php echo esc_html( $data['user_profile']['username'] ); ?></</p>

	<div class="masteriyo-user--role">
		<span><?php echo esc_html( $role_title ); ?></span>
	</div>
</div>
<?php

/**
 * Fires after rendering info section in public profile page.
 *
 * @since 2.6.8
 */
do_action( 'masteriyo_after_public_profile_info' );
