<?php
/**
 * Icon scheme enums.
 *
 * @since 2.5.27
 * @package Masteriyo\Addons\SocialShare
 */

namespace Masteriyo\Addons\SocialShare\Enums;

defined( 'ABSPATH' ) || exit;

/**
 * Icon scheme enum class.
 *
 * @since 2.5.27
 */
class IconScheme {
	/**
	 * Default.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const DEFAULT = 'default';

	/**
	 * Light.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const LIGHT = 'light';

	/**
	 * Dark.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const DARK = 'dark';

	/**
	 * Return all the Icon scheme.
	 *
	 * @since 2.5.27
	 *
	 * @return array
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters Icon scheme list.
			 *
			 * @since 2.5.27
			 *
			 * @param string[] $statuses Icon scheme list.
			 */
			apply_filters(
				'masteriyo_social_share_icon_schemes',
				array(
					self::DEFAULT,
					self::LIGHT,
					self::DARK,
				)
			)
		);
	}
}
