<?php
/**
 * Icon shape enums.
 *
 * @since 2.5.27
 * @package Masteriyo\Addons\SocialShare
 */

namespace Masteriyo\Addons\SocialShare\Enums;

defined( 'ABSPATH' ) || exit;

/**
 * Icon shape enum class.
 *
 * @since 2.5.27
 */
class IconShape {
	/**
	 * Default.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const ROUND = 'round';

	/**
	 * Light.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const SQUARE = 'square';

	/**
	 * Dark.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const RECTANGLE = 'rectangle';

	/**
	 * Return all the Icon shape.
	 *
	 * @since 2.5.27
	 *
	 * @return array
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters Icon shape list.
			 *
			 * @since 2.5.27
			 *
			 * @param string[] $statuses Icon shape list.
			 */
			apply_filters(
				'masteriyo_social_share_icon_shapes',
				array(
					self::ROUND,
					self::SQUARE,
					self::RECTANGLE,
				)
			)
		);
	}
}
