<?php
/**
 * Social service enums.
 *
 * @since 2.5.27
 * @package Masteriyo\Addons\SocialShare
 */

namespace Masteriyo\Addons\SocialShare\Enums;

defined( 'ABSPATH' ) || exit;

/**
 * Social service enum class.
 *
 * @since 2.5.27
 */
class SocialService {
	/**
	 * Facebook.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const FACEBOOK = 'facebook';

	/**
	 * Twitter.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const TWITTER = 'twitter';

	/**
	 * LinkedIn.
	 *
	 * @since 2.5.27
	 * @var string
	 */
	const LINKEDIN = 'linkedin';

	/**
	 * Return all the Social service.
	 *
	 * @since 2.5.27
	 *
	 * @return array
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters Social service list.
			 *
			 * @since 2.5.27
			 *
			 * @param string[] $statuses Social service list.
			 */
			apply_filters(
				'masteriyo_social_share_social_services',
				array(
					self::FACEBOOK,
					self::TWITTER,
					self::LINKEDIN,
				)
			)
		);
	}
}
