<?php
/**
 * Store global social share options.
 *
 * @since 2.5.27
 * @package \Masteriyo\Addons\SocialShare
 */

namespace Masteriyo\Addons\SocialShare;

use Masteriyo\Addons\SocialShare\Enums\IconScheme;
use Masteriyo\Addons\SocialShare\Enums\IconShape;
use Masteriyo\Addons\SocialShare\Enums\SocialService;

class Setting {

	/**
	 * Global option name.
	 *
	 * @since 2.5.27
	 */
	const OPTION_NAME = 'masteriyo_social_share_settings';

	/**
	 * Data.
	 *
	 * @since 2.5.27
	 *
	 * @var array
	 */
	protected static $data = array(
		'title'            => 'Share on social media',
		'size'             => 32,
		'shape'            => IconShape::ROUND,
		'scheme'           => IconScheme::DEFAULT,
		'sharing_services' => array(
			SocialService::FACEBOOK => true,
			SocialService::TWITTER  => true,
			SocialService::LINKEDIN => true,
		),
	);

	/**
	 * Read the settings.
	 *
	 * @since 2.5.27
	 */
	protected static function read() {
		$settings   = get_option( self::OPTION_NAME, self::$data );
		self::$data = masteriyo_parse_args( $settings, self::$data );

		return self::$data;
	}

	/**
	 * Return all the settings.
	 *
	 * @since 2.5.27
	 *
	 * @return mixed
	 */
	public static function all() {
		return self::read();
	}

	/**
	 * Return global white field value.
	 *
	 * @since 2.5.27
	 *
	 * @param string $key
	 * @return string|array
	 */
	public static function get( $key ) {
		self::read();

		return masteriyo_array_get( self::$data, $key, null );
	}

	/**
	 * Set global social share field.
	 *
	 * @since 2.5.27
	 *
	 * @param string $key Setting key.
	 * @param mixed $value Setting value.
	 */
	public static function set( $key, $value ) {
		masteriyo_array_set( self::$data, $key, $value );
		self::save();
	}

	/**
	 * Set multiple settings.
	 *
	 * @since 2.5.27
	 *
	 * @param array $args
	 */
	public static function set_props( $args ) {
		self::$data = masteriyo_parse_args( $args, self::$data );
	}

	/**
	 * Save the settings.
	 *
	 * @since 2.5.27
	 */
	public static function save() {
		update_option( self::OPTION_NAME, self::$data );
	}
}
