<?php
/**
 * Facebook.
 *
 * @package Masteriyo\SocialShare
 *
 * @since 2.5.27
 */

namespace Masteriyo\Addons\SocialShare\SocialShare;

use Masteriyo\Addons\SocialShare\Setting;

defined( 'ABSPATH' ) || exit;

/**
 * Facebook class.
 *
 */
class Facebook {

	/**
	 * Name for the Facebook.
	 *
	 * @var string
	 *
	 * @since 2.5.27
	 */
	protected $name = 'facebook';

	/**
	 * Facebook share URL.
	 *
	 * @return string Facebook share URL.
	 *
	 * @since 2.5.27
	 */
	public function share_url( $url ) {
		return 'https://www.facebook.com/sharer/sharer.php?u=' . rawurlencode( $url );
	}

	/**
	 * Get the name for Facebook share button.
	 *
	 * @return string Name for Facebook share button.
	 *
	 * @since 2.5.27
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Get the title for Facebook share button.
	 *
	 * @return string Title for Facebook share button.
	 *
	 * @since 2.5.27
	 */
	public function get_title() {
		return __( 'Share on Facebook', 'learning-management-system' );
	}

	/**
	 * Checks whether the Facebook is enabled or not.
	 *
	 * @return bool Returns true if enabled, otherwise false.
	 *
	 * @since 2.5.27
	 */
	public function is_enabled() {
		return Setting::get( 'sharing_services.facebook' );
	}
}
