<?php
/**
 * LinkedIn.
 *
 * @package Masteriyo\SocialShare
 *
 * @since 2.5.27
 */

namespace Masteriyo\Addons\SocialShare\SocialShare;

use Masteriyo\Addons\SocialShare\Setting;

defined( 'ABSPATH' ) || exit;

/**
 * LinkedIn class.
 *
 */
class LinkedIn {

	/**
	 * Name for the LinkedIn.
	 *
	 * @var string
	 *
	 * @since 2.5.27
	 */
	protected $name = 'linkedin';

	/**
	 * LinkedIn share URL.
	 *
	 * @return string LinkedIn share URL.
	 *
	 * @since 2.5.27
	 */
	public function share_url( $url ) {
		return 'https://www.linkedin.com/sharing/share-offsite/?url=' . rawurlencode( $url ) . '&title=&summary=&source=';
	}

	/**
	 * Get the name for LinkedIn share button.
	 *
	 * @return string Name for LinkedIn share button.
	 *
	 * @since 2.5.27
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Get the title for LinkedIn share button.
	 *
	 * @return string Title for LinkedIn share button.
	 *
	 * @since 2.5.27
	 */
	public function get_title() {
		return __( 'Share on LinkedIn', 'learning-management-system' );
	}

	/**
	 * Checks whether the LinkedIn is enabled or not.
	 *
	 * @return bool Returns true if enabled, otherwise false.
	 *
	 * @since 2.5.27
	 */
	public function is_enabled() {
		return Setting::get( 'sharing_services.linkedin' );
	}
}
