<?php
/**
 * Masteriyo course social share elementor widget class.
 *
 * @package Masteriyo\Addons\SocialShare
 *
 * @since 2.12.2
 */

namespace Masteriyo\Addons\SocialShare;

use Elementor\Controls_Manager;
use Masteriyo\Addons\ElementorIntegration\Helper;
use Masteriyo\Addons\ElementorIntegration\WidgetBase;
use Masteriyo\Pro\Addons;

defined( 'ABSPATH' ) || exit;

/**
 * Masteriyo course SocialShare elementor widget class.
 *
 * @package Masteriyo\Addons\SocialShare
 *
 * @since 2.12.2
 */
class SocialShareMetaWidget extends WidgetBase {

	/**
	 * Get widget name.
	 *
	 * @since 2.12.2
	 *
	 * @return string
	 */
	public function get_name() {
		return 'masteriyo-social-share-meta-widget';
	}

	/**
	 * Get widget title.
	 *
	 * @since 2.12.2
	 *
	 * @return string
	 */
	public function get_title() {
		return __( 'Masteriyo Social Share', 'learning-management-system' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 2.12.2
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'social-share-meta-widget-icon';
	}

	/**
	 * Get widget keywords.
	 *
	 * @since 2.12.2
	 *
	 * @return string[]
	 */
	public function get_keywords() {
		return array( 'social share', 'share', 'social', 'masteriyo' );
	}

	/**
	 * Register controls configuring widget content.
	 *
	 * @since 2.12.2
	 */
	protected function register_content_controls() {}

	/**
	 * Register controls for customizing widget styles.
	 *
	 * @since 2.12.2
	 */
	protected function register_style_controls() {

		$this->register_social_share_styles_section();

	}

	/**
	 * Register SocialShare style controls section.
	 *
	 * @since 2.12.2
	 */
	protected function register_social_share_styles_section() {

		$this->start_controls_section(
			'social_share_icon_styles',
			array(
				'label' => __( 'Masteriyo Social Share', 'learning-management-system' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'default_styles',
			array(
				'type'      => Controls_Manager::HIDDEN,
				'selectors' => array(
					'{{WRAPPER}} .masteriyo-single-course-social-media-icons' => 'display:flex;',
				),
			)
		);

		$this->add_control(
			'social_share_text_font_size',
			array(
				'label'      => __( 'Text Font Size', 'learning-management-system' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 18,
					'unit' => 'px',
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 300,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .masteriyo-single-course-social-share .title' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				),
			)
		);

		$this->add_control(
			'social_share_text_color',
			array(
				'label'     => __( 'Text Color', 'learning-management-system' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .masteriyo-single-course-social-share .title' => 'color: {{VALUE}} !important;',
				),
			)
		);

		$this->add_control(
			'social_share_icon_background_color',
			array(
				'label'     => __( 'Icon Background Color', 'learning-management-system' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .masteriyo-single-course-social-media-icons .social-icon-wrapper' => 'background-color: {{VALUE}} !important;',
				),
			)
		);

		$this->add_control(
			'social_share_icon_color',
			array(
				'label'     => __( 'Icon Color', 'learning-management-system' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .masteriyo-single-course-social-media-icons svg path' => 'fill: {{VALUE}} !important;',
				),
			)
		);

		$this->add_control(
			'social_share_icon_size',
			array(
				'label'      => __( 'Icon Size', 'learning-management-system' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'default'    => array(
					'size' => 24,
					'unit' => 'px',
				),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 300,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .masteriyo-single-course-social-media-icons a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .masteriyo-single-course-social-media-icons svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',

				),
			)
		);

		$this->add_control(
			'social_share_spacing',
			array(
				'label'      => __( 'Spacing', 'learning-management-system' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .masteriyo-single-course-social-media-icons a' => 'margin-left: {{SIZE}}{{UNIT}};',

				),
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Render course SocialShare widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 2.12.2
	 */
	protected function content_template() {
		$course = Helper::get_elementor_preview_course();

		if ( ! $course ) {
			return;
		}
		if ( ! ( new Addons() )->is_active( MASTERIYO_SOCIAL_SHARE_SLUG ) ) {
			return;
		}

		do_action( 'masteriyo_elementor_social_share_widget', $course );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * @since 2.12.2
	 */
	protected function render() {
		$course = $this->get_course_to_render();
		if ( ! ( new Addons() )->is_active( MASTERIYO_SOCIAL_SHARE_SLUG ) ) {
			return;
		}
		if ( $course ) {
			do_action( 'masteriyo_elementor_social_share_widget', $course );
		}
	}
}
