<?php
/**
 * The Template for displaying social sharing section in single course page
 *
 *
 * @package Masteriyo\Templates
 * @version 2.5.27
 */

use Masteriyo\Addons\SocialShare\Svg;

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering social share section in single course page.
 *
 * @since 2.5.27
 *
 * @param \Masteriyo\Models\Course $course
 */
do_action( 'masteriyo_before_single_course_social_share', $course );
?>

<div class="masteriyo-single-course-social-share">
	<h5 class="title"><?php echo esc_html( $title ); ?></h5>
	<div class="masteriyo-single-course-social-media-icons <?php echo esc_attr( $shape . ' ' . $scheme ); ?>">
	<?php foreach ( $social_shares as $social_share ) : ?>
		<a
			href="<?php echo esc_url( $social_share->share_url( $course->get_permalink() ) ); ?>"
			class="social-icon-wrapper <?php echo esc_attr( $social_share->get_name() ); ?>"
			target="_blank"
			rel="noopener noreferrer"
			style="--size: <?php echo esc_attr( $size ); ?>;"
			title="<?php echo esc_attr( $social_share->get_title() ); ?>"
		>
			<?php Svg::get( $social_share->get_name(), true ); ?>
		</a>
	<?php endforeach; ?>
	</div>
</div>

<?php
/**
 * Fires after rendering social share section in single course page.
 *
 * @since 2.5.27
 *
 * @param \Masteriyo\Models\Course $course
 */
do_action( 'masteriyo_after_single_course_social_share', $course );
