<?php
/**
 * Enums for OTP methods.
 *
 * This file defines the One-Time Password (OTP) method constants for Masteriyo's Two Factor Authentication feature.
 *
 * @since 2.7.0
 *
 * @package Masteriyo\Addons\TwoFactorAuthentication\Enums
 */

namespace Masteriyo\Addons\TwoFactorAuthentication\Enums;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Class OTPMethods
 *
 * Defines the constants for different OTP methods.
 *
 * @since 2.7.0
 */
class OTPMethods {
	/**
	 * Represents OTP via email.
	 *
	 * @since 2.7.0
	 */
	const METHOD_EMAIL = 'email';

	/**
	 * Represents OTP via SMS.
	 *
	 * @since 2.7.0
	 */
	const METHOD_SMS = 'sms';

	/**
	 * Return all the OTP method constants.
	 *
	 * This function returns an array of all the OTP method constants.
	 * Filters are applied for further extensibility.
	 *
	 * @since 2.7.0
	 *
	 * @return array An array of OTP method constants.
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters the OTP methods list.
			 *
			 * Allows modification of the OTP methods list through a filter.
			 *
			 * @since 2.7.0
			 *
			 * @param string[] $methods Array of OTP method constants.
			 */
			apply_filters(
				'masteriyo_two_factor_authentication_otp_methods',
				array(
					self::METHOD_EMAIL,
					self::METHOD_SMS,
				)
			)
		);
	}
}
