<?php
/**
 * Zapier setting.
 *
 * @package Masteriyo\Addons\Zapier
 * @since 2.12.0
 */

namespace Masteriyo\Addons\Zapier;

defined( 'ABSPATH' ) || exit;

/**
 * Zapier setting class.
 */
class Setting {

	const OPTION_NAME = 'masteriyo_zapier';

	/**
	 * Setting data.
	 *
	 * @var array
	 */
	protected static $data = array(
		'api_key'       => '',
		'subscriptions' => array(),
		'user_id'       => 0,
	);

	/**
	 * Read the settings.
	 *
	 * @since 2.12.0
	 */
	public static function read() {
		$settings   = get_option( self::OPTION_NAME, self::$data );
		self::$data = masteriyo_parse_args( $settings, self::$data );

		return self::$data;
	}

	/**
	 * Return all the settings.
	 *
	 * @since 2.12.0
	 *
	 * @return mixed
	 */
	public static function all() {
		return self::read();
	}

	/**
	 * Return global zapier value.
	 *
	 * @since 2.12.0
	 *
	 * @param string $key
	 * @param mixed $default_value
	 * @return mixed
	 */
	public static function get( $key, $default_value = null ) {
		self::read();

		return masteriyo_array_get( self::$data, $key, $default_value );
	}

	/**
	 * Set global zapier field.
	 *
	 * @since 2.12.0
	 *
	 * @param string $key Setting key.
	 * @param mixed $value Setting value.
	 */
	public static function set( $key, $value ) {
		masteriyo_array_set( self::$data, $key, $value );
		self::save();
	}

	/**
	 * Set multiple settings.
	 *
	 * @since 2.12.0
	 *
	 * @param array $args
	 */
	public static function set_props( $args ) {
		self::$data = masteriyo_parse_args( $args, self::$data );
	}

	/**
	 * Save the settings.
	 *
	 * @since 2.12.0
	 */
	public static function save() {
		update_option( self::OPTION_NAME, self::$data );
	}
}
