<?php
/**
 * Addon Name: Zapier Integration
 * Addon URI: https://masteriyo.com/wordpress-lms/
 * Description: Enhance your Learning Management System with Zapier integration. Automate tasks, streamline workflows, and create personalized learning experiences effortlessly.
 * Author: Masteriyo
 * Author URI: https://masteriyo.com
 * Addon Type: Feature
 * Plan: Starter
 */

use Masteriyo\Pro\Addons;
use Masteriyo\Addons\Zapier\ZapierAddon;

define( 'MASTERIYO_ZAPIER_ADDON_FILE', __FILE__ );
define( 'MASTERIYO_ZAPIER_ADDON_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_ZAPIER_ADDON_DIR', __DIR__ );
define( 'MASTERIYO_ZAPIER_ADDON_TEMPLATES', __DIR__ . '/templates' );
define( 'MASTERIYO_ZAPIER_ADDON_ASSETS_URL', plugins_url( 'assets', MASTERIYO_ZAPIER_ADDON_FILE ) );
define( 'MASTERIYO_ZAPIER_ADDON_SLUG', 'zapier' );

// Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_ZAPIER_ADDON_SLUG ) ) {
	return;
}

require_once __DIR__ . '/helpers/zapier.php';
require_once __DIR__ . '/helpers/sample.php';

// Initialize the Zapier addon.
ZapierAddon::instance()->init();
