<?php
/**
 * zoom service provider.
 *
 * @since 2.5.19
 */

namespace Masteriyo\Addons\Zoom\Providers;

defined( 'ABSPATH' ) || exit;

use Masteriyo\Addons\Zoom\ZoomAddon;
use Masteriyo\Addons\Zoom\Models\Zoom;
use Masteriyo\Addons\Zoom\Query\ZoomQuery;
use Masteriyo\Addons\Zoom\RestApi\ZoomController;
use Masteriyo\Addons\Zoom\Jobs\CheckZoomActiveJob;
use Masteriyo\Addons\Zoom\Repository\ZoomRepository;
use Masteriyo\Addons\Zoom\Jobs\CheckZoomExpirationJob;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * zoom service provider.
 *
 * @since 2.5.19
 */
class ZoomServiceProvider extends AbstractServiceProvider {
	/**
	 * The provided array is a way to let the container
	 * know that a service is provided by this service
	 * provider. Every service that is registered via
	 * this service provider must have an alias added
	 * to this array or it will be ignored
	 *
	 * @since 2.5.19
	 *
	 * @var array
	 */
	protected $provides = array(
		'addons.zoom',
		ZoomAddon::class,
		'zoom',
		'zoom.store',
		'zoom.rest',
		'mto-zoom',
		'mto-zoom.store',
		'mto-zoom.rest',
		'query.zoom',
		ZoomQuery::class,

	);

	/**
	 * This is where the magic happens, within the method you can
	 * access the container and register or retrieve anything
	* that you need to, but remember, every alias registered
	 * within this method must be declared in the `$provides` array.
	 *
	 * @since 2.5.19
	 */
	public function register() {
		$this->getContainer()->add( 'addons.zoom', ZoomAddon::class, true );

		// Zoom model
		$this->getContainer()->add( 'zoom.store', ZoomRepository::class );

		$this->getContainer()->add( 'zoom', Zoom::class )
			->addArgument( 'zoom.store' );

		$this->getContainer()->add( 'zoom.rest', ZoomController::class );

		// Zoom Post type
		$this->getContainer()->add( 'mto-zoom.store', ZoomRepository::class );

		$this->getContainer()->add( 'mto-zoom', Zoom::class )
			->addArgument( 'mto-zoom.store' );

		$this->getContainer()->add( 'mto-zoom.rest', ZoomController::class );

		$this->getContainer()->add( ZoomQuery::class );
	}


}
