<?php
/**
 * Addon Name: Zoom
 * Addon URI: https://masteriyo.com/
 * Description: Add Zoom meeting feature to your courses.
 * Author: Masteriyo
 * Author URI: https://masteriyo.com
 * Addon Type: enhancement
 * Plan: Starter
 */

use Masteriyo\Pro\Addons;

define( 'MASTERIYO_ZOOM_ADDON_FILE', __FILE__ );
define( 'MASTERIYO_ZOOM_ADDON_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_ZOOM_ADDON_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_ZOOM_ASSETS', dirname( __FILE__ ) . '/assets' );
define( 'MASTERIYO_ZOOM_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_ZOOM_ADDON_SLUG', 'zoom' );


add_filter(
	'masteriyo_pro_addon_zoom_activation_requirements',
	function ( $result, $request, $controller ) {
		$addons = masteriyo( 'addons' );

		if ( ! $addons->is_allowed( 'zoom' ) ) {
			$result = __( 'This addon is not allowed in your plan.', 'learning-management-system' );
		}

		return $result;
	},
	10,
	3
);

add_filter(
	'masteriyo_pro_addon_data',
	function( $data, $slug ) {
		if ( 'zoom' !== $slug ) {
			return $data;
		}

		$addons                        = masteriyo( 'addons' );
		$fulfilled                     = $addons->is_allowed( 'zoom' ) ? true : false;
		$data['requirement_fulfilled'] = masteriyo_bool_to_string( $fulfilled );

		return $data;
	},
	10,
	2
);

// Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_ZOOM_ADDON_SLUG ) ) {
	return;
}

require_once dirname( __FILE__ ) . '/helper.php';

/**
 * Include service providers for Zoom.
 */
add_filter(
	'masteriyo_service_providers',
	function( $providers ) {
		return array_merge( $providers, require_once dirname( __FILE__ ) . '/config/providers.php' );
	}
);

/**
 * Initialize Masteriyo Zoom.
 */
add_action(
	'masteriyo_before_init',
	function() {
		masteriyo( 'addons.zoom' )->init();
	}
);
