(function ($) {
	var masteriyo_helper = {
		stop_all_videos: function (container) {
			$(container)
				.find('video')
				.each(function () {
					if (this.pause) {
						this.pause();
					}
				});

			$(container)
				.find('iframe')
				.each(function () {
					var iframeSrc = this.src;
					this.src = iframeSrc;
				});
		},

		lockScrolling: function () {
			var scrollPosition = [
				self.pageXOffset ||
					document.documentElement.scrollLeft ||
					document.body.scrollLeft,
				self.pageYOffset ||
					document.documentElement.scrollTop ||
					document.body.scrollTop,
			];

			$('html').data('scroll-position', scrollPosition);
			$('html').data('previous-overflow', $('html').css('overflow'));
			$('html').css('overflow', 'hidden');

			window.scrollTo(scrollPosition[0], scrollPosition[1]);
		},

		unlockScrolling: function () {
			var scrollPosition = $('html').data('scroll-position');
			var overflow = $('html').data('previous-overflow');

			if (overflow) {
				$('html').css('overflow', overflow);
			}
			if (scrollPosition) {
				window.scrollTo(scrollPosition[0], scrollPosition[1]);
			}
		},
	};

	var filtersSidebar = {
		$sidebar: $('.masteriyo-courses-filters'),

		openFiltersSidebar: function () {
			var scrollTop =
				self.pageYOffset ||
				document.documentElement.scrollTop ||
				document.body.scrollTop;
			var sidebarTopPadding = 20;

			this.$sidebar.addClass('masteriyo-expanded');

			if (
				$('#wpadminbar').css('position') === 'fixed' ||
				scrollTop < $('#wpadminbar').height() - sidebarTopPadding
			) {
				this.$sidebar.addClass('masteriyo-add-admin-bar-margin');
			}
			masteriyo_helper.lockScrolling();
		},

		closeFiltersSidebar: function () {
			this.$sidebar.removeClass('masteriyo-expanded');
			this.$sidebar.removeClass('masteriyo-add-admin-bar-margin');
			masteriyo_helper.unlockScrolling();
		},

		isFiltersSidebarOpen: function () {
			return this.$sidebar.hasClass('masteriyo-expanded');
		},

		toggleFiltersSidebar: function () {
			if (this.isFiltersSidebarOpen()) {
				this.closeFiltersSidebar();
			} else {
				this.openFiltersSidebar();
			}
		},
	};

	var MasteriyoCourses = {
		/**
		 * The current view mode of the courses.
		 * @type {string}
		 */
		currentViewMode: getCookie('MasteriyoCoursesViewMode'),

		/**
		 * The view mode items in the UI.
		 * @type {jQuery}
		 */
		viewModeItems: null,

		/**
		 * Initializes the MasteriyoCourses module.
		 */
		init: function () {
			this.viewModeItems = $('.masteriyo-courses-view-mode-item');
			this.bindUIActions();

			if (
				'grid-view' === this.currentViewMode ||
				'list-view' === this.currentViewMode
			) {
				this.setViewMode(this.currentViewMode);
			}

			$(document).ready(function () {
				MasteriyoCourses.init_password_projected_form_handler();
			});
		},

		/**
		 * Binds event handlers to elements.
		 */
		bindUIActions: function () {
			this.viewModeItems.on('click', '.view-mode', function () {
				var mode = $(this).data('mode');

				MasteriyoCourses.setViewMode(mode);

				MasteriyoCourses.viewModeItems.removeClass('active');

				$(this).closest('.masteriyo-courses-view-mode-item').addClass('active');
			});
		},

		/**
		 * Sets the view mode for the courses.
		 * @param {string} mode - The view mode to set ('list-view' or 'grid-view').
		 */
		setViewMode: function (mode) {
			setCookie('MasteriyoCoursesViewMode', mode, 365);

			var coursesClass =
				$(
					'.masteriyo-courses-view-mode-section .masteriyo-courses-view-mode-item-lists',
				).data('courses-class') || 'masteriyo-course';

			var courseItems = $(
				`.masteriyo-course-list-display-section .${coursesClass}`,
			);

			courseItems.removeClass('list-view');
			courseItems.removeClass('grid-view');

			MasteriyoCourses.viewModeItems.removeClass('active');

			var activeItem = this.viewModeItems
				.find('.view-mode[data-mode="' + mode + '"]')
				.parent();
			activeItem.addClass('active');

			courseItems.addClass(mode);

			this.currentViewMode = mode;
		},
		/**
		 * Initializes the password-protected form handler.
		 *
		 * This function sets up event listeners for the password-protected form modal,
		 * allowing users to enter a password and access a protected project.
		 *
		 * @since 1.8.0
		 */
		init_password_projected_form_handler: function () {
			var $passwordProjectedBtn = $('.masteriyo-password-protected');
			var protectedCourseId = 0;

			var $submitBtn = $(
				'#masteriyoCoursePasswordProtectedModal .masteriyo-submit',
			);

			var originalSubmitBtnText = $submitBtn.text();
			var submitBtnText = originalSubmitBtnText;

			/** Submit data. */
			function onSubmit(e) {
				e.preventDefault();

				submitBtnText = $submitBtn.data('loading-text');
				$submitBtn.text(submitBtnText);
				$submitBtn.prop('disabled', true);

				var password = $('#masteriyoPostPassword').val();
				if (!password) {
					if (
						_MASTERIYO_COURSES_.labels &&
						_MASTERIYO_COURSES_.labels.password_not_empty
					) {
						$('#passwordError')
							.text(_MASTERIYO_COURSES_.labels.password_not_empty)
							.show();

						submitBtnText = originalSubmitBtnText;
						$submitBtn.text(submitBtnText);
						$submitBtn.prop('disabled', false);
					}
					return;
				}
				$.ajax({
					type: 'POST',
					dataType: 'json',
					data: {
						action: 'masteriyo_course_password_protection',
						nonce: _MASTERIYO_COURSES_.password_protected_nonce,
						password,
						course_id: protectedCourseId,
					},
					url: _MASTERIYO_COURSES_.ajaxURL,
					success: function (response) {
						submitBtnText = originalSubmitBtnText;
						$submitBtn.text(submitBtnText);
						$submitBtn.prop('disabled', false);

						if (response.success) {
							$('#masteriyoPostPassword').val('');
							$('#passwordError').text('');
							$('#masteriyoCoursePasswordProtectedModal').addClass(
								'masteriyo-hidden',
							);

							if (response.data && response.data.start_url) {
								window.open(response.data.start_url);
							}
						} else {
							if (response.data && response.data.message) {
								$('#passwordError').text(response.data.message).show();
							}
						}
					},
					error: function (xhr) {
						submitBtnText = originalSubmitBtnText;
						$submitBtn.text(submitBtnText);
						$submitBtn.prop('disabled', false);

						var errorMessage = 'An error occurred';
						if (
							xhr.responseJSON &&
							xhr.responseJSON.data &&
							xhr.responseJSON.data.message
						) {
							errorMessage = xhr.responseJSON.data.message;
						}
						$('#passwordError').text(errorMessage).show();
					},
				});
			}

			$passwordProjectedBtn.on('click', function (e) {
				e.preventDefault();
				protectedCourseId = $(this).attr('href').split('=')[1];
				$('#masteriyoCoursePasswordProtectedModal').removeClass(
					'masteriyo-hidden',
				);
			});

			$('#masteriyoCoursePasswordProtectedModal .masteriyo-cancel').on(
				'click',
				function (e) {
					e.preventDefault();
					$('#masteriyoCoursePasswordProtectedModal').addClass(
						'masteriyo-hidden',
					);
				},
			);

			$('#masteriyoCoursePasswordProtectedModal form').on(
				'submit',
				function (e) {
					e.preventDefault();
				},
			);

			$('#masteriyoCoursePasswordProtectedModal .masteriyo-submit').on(
				'click',
				function (e) {
					onSubmit(e);
				},
			);

			$('#masteriyoCoursePasswordProtectedModal form').keypress(function (e) {
				if (e.which == 13) {
					onSubmit(e);
				}
			});
		},
	};

	/**
	 * Return WordPress spinner.
	 *
	 * @returns string
	 */
	function getSpinner() {
		return '<span class="spinner" style="visibility:visible"></span>';
	}

	function getBlockLoadingConfiguration() {
		return {
			message: getSpinner(),
			css: {
				border: '',
				width: '0%',
			},
			overlayCSS: {
				background: '#fff',
				opacity: 0.6,
			},
		};
	}

	var filtersAndSorting = {
		currentPage: 0,
		refreshCallsCount: 0,

		refreshCourses: function () {
			filtersAndSorting.refreshCallsCount++;

			var data = {
				action: 'masteriyo_course_filter_and_sorting',
			};

			$('.masteriyo-courses-filters')
				.find('input,select,textarea')
				.each(function () {
					var type = $(this).prop('type');
					var name = $(this).prop('name');

					if ('checkbox' === type) {
						name = name.trim().replace(/\[\]$/, '');

						if (!Array.isArray(data[name])) {
							data[name] = [];
						}

						if ($(this).is(':checked')) {
							data[name].push($(this).val());
						}
					} else {
						data[name] = $(this).val();
					}
				});

			data._wpnonce = $(
				'[name="masteriyo_course_filter_and_sorting_nonce"]',
			).val();
			data.page = filtersAndSorting.currentPage;
			data.rating = $('.masteriyo-rating-filter-link.active').data('rating');
			data.search = $('.search-field.masteriyo-input').val();
			data.orderby = $('select.masteriyo-courses-order-by').val();
			data.order = $('input.masteriyo-courses-sorting-order').val();
			data.layout = $('.masteriyo-course-list-display-section').data('layout');

			$.ajax({
				type: 'POST',
				url: _MASTERIYO_COURSES_.ajaxURL,
				dataType: 'json',
				data: data,
				beforeSend: function (jqXHR) {
					$('.masteriyo-courses-wrapper')
						.addClass('masteriyo-applying-filter')
						.block(getBlockLoadingConfiguration());
				},
				success: function (response, textStatus, jqXHR) {
					var data = response.data;

					if (
						filtersAndSorting.refreshCallsCount <= 1 &&
						data &&
						data.fragments
					) {
						$.each(data.fragments, function (key, value) {
							if (!masteriyo.fragments || masteriyo.fragments[key] !== value) {
								$(key).replaceWith(value);
							}
							$(key).unblock();
						});
						masteriyo.fragments = data.fragments;
					}

					MasteriyoCourses.init();
				},
				error: function (jqXHR, textStatus, errorThrown) {},
				complete: function (jqXHR, textStatus) {
					if (filtersAndSorting.refreshCallsCount <= 1) {
						$('.masteriyo-courses-wrapper')
							.removeClass('masteriyo-applying-filter')
							.unblock();
					}

					filtersAndSorting.refreshCallsCount--;
				},
			});
		},
	};

	var masteriyo = {
		init: function () {
			$(document).ready(function () {
				masteriyo.init_featured_video_modals();
				masteriyo.init_course_search();
				masteriyo.init_course_filters();
				masteriyo.init_course_sorting();
			});
		},

		init_featured_video_modals: function () {
			// Open modal.
			$(document.body).on(
				'click',
				'.masteriyo-play-featured-video-btn',
				function (e) {
					e.preventDefault();

					var $modal = $(this)
						.closest('.masteriyo-col')
						.find('.masteriyo-featured-video-modal');
					var $player = $modal.find('video').length
						? $modal.find('video')
						: $modal.find('iframe');

					if (!$player.attr('src')) {
						$player.attr('src', $player.data('src'));
					}

					$modal.fadeIn();
				},
			);

			// Close modal.
			$(document.body).on(
				'click',
				'.masteriyo-featured-video-modal',
				function (e) {
					if ($(e.target).hasClass('masteriyo-overlay')) {
						$(e.target).fadeOut();
						masteriyo_helper.stop_all_videos(e.target);
					}
				},
			);
		},

		init_course_search: function () {
			if (_MASTERIYO_COURSES_.enableAjaxFilter) {
				$(document.body).on(
					'submit',
					'form.masteriyo-course-search',
					function (e) {
						e.preventDefault();

						filtersAndSorting.currentPage = 0;
						filtersAndSorting.refreshCourses();
					},
				);
			}
		},

		init_course_filters: function () {
			$(document.body).on(
				'click',
				'.masteriyo-toggle-course-filters-sidebar',
				function () {
					filtersSidebar.toggleFiltersSidebar();
				},
			);

			$(document.body).on(
				'click',
				'.masteriyo-close-filters-sidebar, .masteriyo-course-filter-sidebar-overlay',
				function () {
					filtersSidebar.closeFiltersSidebar();
				},
			);

			$(window).on('resize', function () {
				if ($(this).height() <= 768) {
					filtersSidebar.closeFiltersSidebar();
				}
			});

			$(document.body).on(
				'click',
				'button.masteriyo-apply-price-filter',
				function (e) {
					if (_MASTERIYO_COURSES_.enableAjaxFilter) {
						e.preventDefault();
						filtersAndSorting.currentPage = 0;
						filtersAndSorting.refreshCourses();
					} else {
						$(this).closest('form').submit();
					}
				},
			);

			$(document.body).on(
				'change',
				'.masteriyo-courses-filters select, .masteriyo-courses-filters input[type="checkbox"]',
				function () {
					if (_MASTERIYO_COURSES_.enableAjaxFilter) {
						filtersAndSorting.currentPage = 0;
						filtersAndSorting.refreshCourses();
					} else {
						$(this).closest('form').submit();
					}
				},
			);

			$(document.body).on(
				'change',
				'.masteriyo-courses-filters select[name="price-type"]',
				function () {
					if ($(this).val() === 'free') {
						$('.masteriyo-price-filter-section').addClass('masteriyo-hidden');
					} else {
						$('.masteriyo-price-filter-section').removeClass(
							'masteriyo-hidden',
						);
					}
				},
			);

			$(document.body).on(
				'click',
				'.masteriyo-rating-filter-link',
				function (e) {
					if (_MASTERIYO_COURSES_.enableAjaxFilter) {
						e.preventDefault();

						filtersAndSorting.currentPage = 0;

						$('.masteriyo-rating-filter-link').removeClass('active');
						$(this).addClass('active');
						filtersAndSorting.refreshCourses();
					}
				},
			);

			$(document.body).on(
				'click',
				'button.masteriyo-apply-price-filter',
				function (e) {
					if (_MASTERIYO_COURSES_.enableAjaxFilter) {
						filtersAndSorting.currentPage = 0;
						e.preventDefault();
						filtersAndSorting.refreshCourses();
					}
				},
			);

			$(document.body).on('click', '.masteriyo-clear-filters', function (e) {
				if (_MASTERIYO_COURSES_.enableAjaxFilter) {
					e.preventDefault();

					filtersAndSorting.currentPage = 0;

					$('.masteriyo-rating-filter-link').removeClass('active');
					$('.search-field.masteriyo-input').val('');
					$('.masteriyo-courses-filters select[name="price-type"]').val('');
					$('.masteriyo-courses-filters input[name="price-from"]').val('');
					$('.masteriyo-courses-filters input[name="price-to"]').val('');
					$(
						'.masteriyo-courses-filters input[name="categories[]"], .masteriyo-courses-filters input[name="difficulties[]"]',
					).removeAttr('checked');

					$(document.body).trigger('masteriyo_clear_course_filters');

					filtersAndSorting.refreshCourses();
				}
			});

			$(document.body).on(
				'click',
				'.masteriyo-see-more-categories',
				function (e) {
					e.preventDefault();
					$(this).addClass('masteriyo-hidden');
					$('.masteriyo-overflowed-category').removeClass('masteriyo-hidden');
					$('.masteriyo-see-less-categories').removeClass('masteriyo-hidden');
				},
			);

			$(document.body).on(
				'click',
				'.masteriyo-see-less-categories',
				function (e) {
					e.preventDefault();
					$(this).addClass('masteriyo-hidden');
					$('.masteriyo-overflowed-category').addClass('masteriyo-hidden');
					$('.masteriyo-see-more-categories').removeClass('masteriyo-hidden');
				},
			);
		},

		init_course_sorting: function () {
			$(document.body).on(
				'change',
				'select.masteriyo-courses-order-by',
				function () {
					var order = $(this).find('option:selected').data('order');

					$('input.masteriyo-courses-sorting-order').val(order);

					if (_MASTERIYO_COURSES_.enableAjaxFilter) {
						filtersAndSorting.currentPage = 0;
						filtersAndSorting.refreshCourses();
					} else {
						$(this).closest('form').submit();
					}
				},
			);
		},
	};

	masteriyo.init();
	MasteriyoCourses.init();

	/**
	 * Helper function to set a cookie.
	 *
	 * @since 1.6.11
	 *
	 * @param {string} name - The name of the cookie.
	 * @param {string} value - The value to be stored in the cookie.
	 * @param {number} days - The number of days until the cookie expires.
	 */
	function setCookie(name, value, days) {
		var expires = '';
		var DAY_IN_MILLISECONDS = 24 * 60 * 60 * 1000;

		if (days) {
			var date = new Date();
			date.setTime(date.getTime() + days * DAY_IN_MILLISECONDS);
			expires = '; expires=' + date.toGMTString();
		}

		document.cookie = name + '=' + value + expires + '; path=/';
	}

	/**
	 * Helper function to get the value of a cookie by name.
	 *
	 * @since 1.6.11
	 *
	 * @param {string} name - The name of the cookie to retrieve.
	 * @returns {string|null} The value of the cookie, or null if not found.
	 */
	function getCookie(name) {
		var cookieName = name + '=';
		var cookieArray = document.cookie.split(';');
		for (var i = 0; i < cookieArray.length; i++) {
			var cookie = cookieArray[i];
			while (cookie.charAt(0) === ' ') {
				cookie = cookie.substring(1, cookie.length);
			}
			if (cookie.indexOf(cookieName) === 0) {
				return cookie.substring(cookieName.length, cookie.length);
			}
		}
		return null;
	}
})(jQuery, window.masteriyo_data);
