<?php
/**
 * Migration class template used by the wp cli to create migration classes.
 *
 * @since 2.6.10
 */

use Masteriyo\Database\Migration;

class CreatePaymentRetryTable extends Migration {
	/**
	 * Run the migration.
	 *
	 * @since 2.6.10
	 */
	public function up() {
		$sql = "CREATE TABLE {$this->prefix}masteriyo_subscription_ (
			id BIGINT UNSIGNED AUTO_INCREMENT,
			order_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
			status VARCHAR(191) NOT NULL DEFAULT '',
			rules TEXT,
			created_at DATETIME DEFAULT '0000-00-00 00:00:00',
			modified_at DATETIME DEFAULT '0000-00-00 00:00:00',
			PRIMARY KEY  (id),
			KEY order_id (order_id),
			KEY status (status),
			KEY created_at (created_at),
			KEY modified_at (modified_at)
		) $this->charset_collate;";

		dbDelta( $sql );
	}

	/**
	 * Reverse the migrations.
	 *
	 * @since 2.6.10
	 */
	public function down() {
		$this->connection->query( "DROP TABLE IF EXISTS {$this->prefix}masteriyo_payment_retries;" );
	}
}
