<?php
/**
 * License status enums.
 *
 * @since 2.5.0
 * @package Masteriyo\Enums
 */

namespace Masteriyo\Enums;

defined( 'ABSPATH' ) || exit;

/**
 * License status enum class.
 *
 * @since 2.5.0
 */
class LicenseStatus extends PostStatus {
	/**
	 * License active status.
	 *
	 * @since 2.5.0
	 * @var string
	 */
	const ACTIVE = 'active';

	/**
	 * License inactive status.
	 *
	 * @since 2.5.0
	 * @var string
	 */
	const INACTIVE = 'inactive';

	/**
	 * Return all License statuses.
	 *
	 * @since 2.5.0
	 *
	 * @return array
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filters License status list.
			 *
			 * @since 2.5.0
			 *
			 * @param string[] $statuses License status list.
			 */
			apply_filters(
				'masteriyo_license_statuses',
				array(
					self::ACTIVE,
					self::INACTIVE,
				)
			)
		);
	}
}
