<?php
/**
 * Question type enums.
 *
 * @since 1.5.3
 * @package Masteriyo\Enums
 */

namespace Masteriyo\Enums;

defined( 'ABSPATH' ) || exit;

/**
 * Question type enum class.
 *
 * @since 1.5.3
 */
class QuestionType {
	/**
	 * True False question type.
	 *
	 * @since 1.5.3
	 * @var string
	 */
	const TRUE_FALSE = 'true-false';

	/**
	 * Single Choice question type.
	 *
	 * @since 1.5.3
	 * @var string
	 */
	const SINGLE_CHOICE = 'single-choice';

	/**
	 * Multiple Choice question type.
	 *
	 * @since 1.5.3
	 * @var string
	 */
	const MULTIPLE_CHOICE = 'multiple-choice';


	/**
	 * Sortable question type.
	 *
	 * @since 2.4.0
	 * @var string
	 */
	const SORTABLE = 'sortable';

	/**
	 * Text answer question type.
	 * Matching question type.
	 *
	 * @since 2.4.0
	 * @var string
	 */
	const TEXT_ANSWER = 'text-answer';

	/**
	 * Matching question type.
	 *
	 * @since 2.4.0
	 * @var string
	 */
	const MATCHING = 'matching';

	/**
	 * Audio question type.
	 *
	 * @since 2.4.0
	 * @var string
	 */
	const AUDIO = 'audio';

	/**
	 * Video question type.
	 *
	 * @since 2.4.0
	 * @var string
	 */
	const VIDEO = 'video';

	/**
	 * Fill in the blanks.
	 *
	 * @since 2.4.7
	 *
	 * @var string
	 */
	const FILL_IN_THE_BLANKS = 'fill-in-the-blanks';

	/**
	 * Get all question types.
	 *
	 * @since 1.5.3
	 * @static
	 *
	 * @return array
	 */
	public static function all() {
		$types = apply_filters(
			'masteriyo_question_types',
			array(
				self::TRUE_FALSE,
				self::SINGLE_CHOICE,
				self::MULTIPLE_CHOICE,
				self::TEXT_ANSWER,
				self::MATCHING,
				self::AUDIO,
				self::VIDEO,
				self::SORTABLE,
				self::FILL_IN_THE_BLANKS,
			)
		);

		return array_unique( $types );
	}
}
