<?php
/**
 * Class for parameter-based subscription querying
 *
 * @package  Masteriyo\Query
 * @version 2.6.10
 * @since   2.6.10
 */

namespace Masteriyo\Query;

use Masteriyo\Abstracts\ObjectQuery;
use Masteriyo\PostType\PostType;
use Masteriyo\Pro\Enums\SubscriptionStatus;

defined( 'ABSPATH' ) || exit;

/**
 * Subscription query class.
 */
class SubscriptionQuery extends ObjectQuery {

	/**
	 * Valid query vars for subscriptions.
	 *
	 * @since 2.6.10
	 *
	 * @return array
	 */
	protected function get_default_query_vars() {
		return array_merge(
			parent::get_default_query_vars(),
			array(
				'type'                => PostType::SUBSCRIPTION,
				'status'              => SubscriptionStatus::all(),
				'total'               => '',
				'currency'            => '',
				'customer_id'         => '',
				'payment_method'      => '',
				'transaction_id'      => '',
				'created_via'         => '',
				'customer_ip_address' => '',
				'customer_user_agent' => '',
				'date_created'        => '',
				'date_modified'       => '',
				'date_paid'           => '',
				'date_completed'      => '',
			)
		);
	}

	/**
	 * Get subscriptions matching the current query vars.
	 *
	 * @since 2.6.10
	 *
	 * @return \Masteriyo\Pro\Models\Subscription[] Subscription objects
	 */
	public function get_subscriptions() {
		/**
		 * Filters subscription object query args.
		 *
		 * @since 2.6.10
		 *
		 * @param array $query_args The object query args.
		 */
		$args    = apply_filters( 'masteriyo_subscription_object_query_args', $this->get_query_vars() );
		$results = masteriyo( 'subscription.store' )->query( $args );

		/**
		 * Filters subscription object query results.
		 *
		 * @since 2.6.10
		 *
		 * @param \Masteriyo\Pro\Models\Subscription[] $results The query results.
		 * @param array $query_args The object query args.
		 */
		return apply_filters( 'masteriyo_subscription_object_query', $results, $args );
	}
}
