<?php
/**
 * The Template for displaying courses in single course bundle page
 *
 * This template can be overridden by copying it to yourtheme/masteriyo/single-course-bundle/courses.php.
 *
 * HOWEVER, on occasion Masteriyo will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package Masteriyo\Templates
 * @version 2.12.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering highlights section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_before_single_course_bundle_courses_list_item' );

?>

<li class="masteriyo-bundle__courses-item">
	<div class="masteriyo-bundle__courses-item-img">
		<?php echo wp_kses( $course->get_image( 'masteriyo_single' ), 'masteriyo_image' ); ?>
	</div>
	<div class="masteriyo-bundle__courses-item-info">
		<h3 class="masteriyo-course-title"><?php echo esc_html( $course->get_title() ); ?></h3>
		<div class="masteriyo-course-author">
			<?php
			$author = masteriyo_get_user( $course->get_author_id() );
			?>
			<?php if ( $author ) : ?>
				<div class="masteriyo-course-bundle-author masteriyo-course-author">
					By
					<a href="<?php echo esc_url( $author->get_url() ); ?>">
						<?php /* translators: %s: Username */ ?>
						<!-- Do not multiline below code, as it will create space around the display name. -->
						<span class="masteriyo-course-bundle-author--name masteriyo-course-author--name"><?php echo esc_html( $author->get_display_name() ); ?></span>
					</a>
				</div>
			<?php endif; ?>
		</div>
	</div>
	<span class="masteriyo-bundle__courses-item__price">
		<?php echo esc_html( masteriyo_price( $course->get_price(), array( 'html' => false ) ) ); ?>
	</span>
</li>

<?php

/**
 * Fires after rendering highlights section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_after_single_course_bundle_courses_list_item' );
