<?php
/**
 * The Template for displaying courses in single course bundle page
 *
 * This template can be overridden by copying it to yourtheme/masteriyo/single-course-bindle/courses.php.
 *
 * HOWEVER, on occasion Masteriyo will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package Masteriyo\Templates
 * @version 2.12.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering highlights section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_before_single_course_bundle_courses' );

?>

<div class="tab-content masteriyo-bundle-courses masteriyo-hidden masteriyo-bundle__courses">
	<?php
	do_action( 'masteriyo_single_course_bundle_courses_content', $courses );
	?>
</div>

<?php

/**
 * Fires after rendering highlights section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_after_single_course_bundle_courses' );
