<?php
/**
 * The Template for displaying course featured image in single course bundle page
 *
 * This template can be overridden by copying it to yourtheme/masteriyo/single-course-bundle/featured-image.php.
 *
 * HOWEVER, on occasion Masteriyo will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package Masteriyo\Templates
 * @version 2.12.0
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="masteriyo-bundle__featured-img masteriyo-feature-img">
	<?php echo wp_kses( $course_bundle->get_image( 'masteriyo_single' ), 'masteriyo_image' ); ?>
	<?php if ( $course_bundle->has_featured_video() ) : ?>
		<div class="masteriyo-play-featured-video-btn">
			<?php masteriyo_get_svg( 'play', true ); ?>
		</div>
	<?php endif; ?>
</div>
<?php
