<?php
/**
 * The Template for displaying course overview in single course page
 *
 * This template can be overridden by copying it to yourtheme/masteriyo/single-course-bundle/overview.php.
 *
 * HOWEVER, on occasion Masteriyo will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package Masteriyo\Templates
 * @version 2.12.0
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering overview section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_before_single_course_bundle_instructors' );

?>
<div class="masteriyo-bundle__instructors">
	<h5><?php esc_html_e( 'Instructors', 'learning-management-system' ); ?></h5>
	<?php
	foreach ( $instructors as $instructor ) {
		?>
		<div class="masteriyo-bundle__instructor">
		<a href="<?php echo esc_url( $instructor->get_course_archive_url() ); ?>">
			<img src="<?php echo esc_attr( $instructor->profile_image_url() ); ?>"
				alt="<?php echo esc_attr( $instructor->get_display_name() ); ?>"
				title="<?php echo esc_attr( $instructor->get_display_name() ); ?>"
			>
			<?php /* translators: %s: Username */ ?>
			<!-- Do not multiline below code, as it will create space around the display name. -->
			<span class="masteriyo-bundle__instructor-name"><?php echo esc_html( $instructor->get_display_name() ); ?></span>
		</a>
	</div>
		<?php
	}
	?>
</div>
<?php

/**
 * Fires after rendering overview section in single course page.
 *
 * @since 2.12.0
 */
do_action( 'masteriyo_after_single_course_bundle_instructors' );
