<?php
/**
 * UserRegistrationFileUpload Admin.
 *
 * @class    URFU_Uploaded_Data
 * @version  1.0.0
 * @package  UserRegistrationFileUpload/Admin
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * URFU_Uploaded_Data Class
 */
class URFU_Uploaded_Data {

	/**
	 * User wise file data.
	 *
	 * @var array
	 */
	public static $userwise_file_data = array();

	/**
	 * Render uploaded file data.
	 *
	 * @param array $post_ids Ids of user registration forms.
	 */
	public static function render_data( $post_ids = array() ) {

		$user_wise_form_data = array();
		$args                = array(
			'post_type' => 'user_registration',
			'status'    => 'publish',
			'post__in'  => $post_ids,

		);
		$posts_array         = get_posts( $args );

		foreach ( $posts_array as $post ) {
			$users = get_users(
				array(
					'meta_key'   => 'ur_form_id',
					'meta_value' => $post->ID,
				)
			);

			$form_data_object = json_decode( $post->post_content ) or array();

			$file_field = self::get_file_field( $form_data_object );

			foreach ( $users as $user ) {

				$user_data = self::get_user_data( $user, $file_field );
				foreach ( $user_data as $single_user_data ) {

					array_push( $user_wise_form_data, $single_user_data );
				}
			}

			self::$userwise_file_data = $user_wise_form_data;

		}

	}

	/**
	 * Get user data.
	 *
	 * @param object $user User data.
	 * @param array $file_field File field data.
	 */
	public static function get_user_data( $user, $file_field ) {

		$user_data_array = array();

		if ( ! isset( $user->ID ) ) {

			return $user_data_array;
		}

		foreach ( $file_field as $field ) {

			$user_data['ID'] = $user->ID;

			$meta_key = isset( $field['key'] ) ? $field['key'] : '';

			$attachment_id = get_user_meta( $user->ID, 'user_registration_' . $meta_key, true );

			$file_name = basename( get_attached_file( $attachment_id ) );

			$user_data['attachment_id'] = empty( $attachment_id ) ? __( 'Attachment not found.', 'user-registration-file-upload' ) : $attachment_id;

			$user_data['file_name'] = empty( $attachment_id ) ? __( 'File not found.', 'user-registration-file-upload' ) : $file_name;

			$user_data['user_login'] = $user->data->user_login;

			$user_data['user_email'] = $user->data->user_email;

			if ( ! empty( $attachment_id ) ) {
				array_push( $user_data_array, $user_data );
			}
		}

		return $user_data_array;

	}

	/**
	 * Get file field.
	 *
	 * @param array $form_data Form data.
	 * @param string $type Input type.
	 */
	public static function get_file_field( $form_data, $type = 'file' ) {

		$file_field = array();

		foreach ( $form_data as $data ) {

			foreach ( $data as $single_data_index => $single_data ) {

				foreach ( $single_data as $field_data ) {

					if ( isset( $field_data->field_key ) && $field_data->field_key === $type ) {

						if ( isset( $field_data->general_setting ) && isset( $field_data->general_setting->field_name ) ) {

							$file_field[] = array(
								'label' => $field_data->general_setting->label,
								'key'   => $field_data->general_setting->field_name,
							);

						}
					}
				}
			}
		}

		return $file_field;
	}

	/**
	 * Make zip.
	 */
	public static function make_zip() {

		if ( ! class_exists( 'ZipArchive' ) ) {

			return false;
		}

		$files_to_zip = array(); // create array.
		foreach ( self::$userwise_file_data as $single_data ) {
			$attachment_ids = explode( ',', $single_data['attachment_id'] );
			foreach ( $attachment_ids as $attachment_id ) {
				// code...
				if ( (int) $attachment_id > 0 ) {

					$files_to_zip [] =
						array(
							'user_id' => $single_data['ID'],
							'file'    => ( get_attached_file( $attachment_id ) ),
						); // populate files array.

				}
			}
		}

		$zip        = new ZipArchive();
		$upload_dir = wp_get_upload_dir();
		$file_path  = $upload_dir['path'] . DIRECTORY_SEPARATOR . 'user_registration.zip';

		$opened = $zip->open( $file_path, ZipArchive::CREATE );

		if ( true !== $opened ) {
			return false;
		}
		if ( $files_to_zip ) {
			foreach ( $files_to_zip as $attachment ) {
				if ( ! empty( $attachment['file'] ) ) {
					$new_filename = substr( $attachment['file'], strrpos( $attachment['file'], '/' ) + 1 );
					$user_info    = apply_filters( 'user_registration_filename', 'UserID-' . $attachment['user_id'], $attachment );
					$zip->addFile( $attachment['file'], $user_info . '_' . $new_filename );
				}
			}
		}
		$zip->close();

		if ( file_exists( $file_path ) ) {
			return true;
		}

		return false;

	}

}
