<?php
/**
 * UserRegistrationFileUpload Admin.
 *
 * @class    UR_File
 * @version  1.0.0
 * @package  UserRegistrationFileUpload/Form
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * UR_File Class
 */
class UR_File extends UR_Form_Field {

	private static $_instance;


	/**
	 * Get instance.
	 *
	 * @return UR_File
	 */
	public static function get_instance() {
		// If the single instance hasn't been set, set it now.
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Hook in tabs.
	 */
	public function __construct() {

		$this->id = 'user_registration_file';

		$this->form_id = 1;

		$this->registered_fields_config = array(

			'label' => __( 'File Upload', 'user-registration-file-upload' ),

			'icon'  => 'ur-icon ur-icon-file-upload',
		);
		$this->field_defaults           = array(

			'default_label'      => __( 'File Upload', 'user-registration-file-upload' ),

			'default_field_name' => 'file_' . ur_get_random_number(),
		);
	}


	/**
	 * Add File upload field in fields list.
	 *
	 * @return string
	 */
	public function get_registered_admin_fields() {

		return '<li id="' . $this->id . '_list "

				class="ur-registered-item draggable"

                data-field-id="' . $this->id . '"><span class="' . $this->registered_fields_config['icon'] . '"></span>' . $this->registered_fields_config['label'] . '</li>';
	}


	/**
	 * Validation for file upload field.
	 *
	 * @param mixed $single_form_field Single form field.
	 * @param mixed $form_data Form Data.
	 * @param mixed $filter_hook Filter hook.
	 * @param int   $form_id Form id.
	 */
	public function validation( $single_form_field, $form_data, $filter_hook, $form_id ) {
		// Custom Field Validation here..
	}
}

return UR_File::get_instance();
