<?php
/**
 * UserRegistrationFileUpload Field Settings
 *
 * @class    UR_Setting_File
 * @version  1.0.0
 * @package  UserRegistrationFileUpload/Form
 * @category Admin
 * @author   WPEverest
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Abstract UR Setting File Upload Class.
 *
 * @version  1.0.0
 * @package  UserRegistration/Form/Settings
 * @category Abstract Class
 * @author   WPEverest
 */
class UR_Setting_File extends UR_Field_Settings {

	/**
	 * Construct.
	 */
	public function __construct() {

		$this->field_id = 'file_advance_setting';

	}

	/**
	 * Outputs File upload field settings.
	 *
	 * @param array $field_data Field data.
	 */
	public function output( $field_data = array() ) {

		// TODO: Implement output() method.
		$this->field_data = $field_data;

		$this->register_fields();

		$field_html = $this->fields_html;

		return $field_html;
	}

	/**
	 * Register advance settings for file upload field.
	 */
	public function register_fields() {
		// TODO: Implement register_fields() method.
		$fields = array(

			'custom_class'    => array(
				'label'       => __( 'Custom Class', 'user-registration-file-upload' ),
				'data-id'     => $this->field_id . '_custom_class',
				'name'        => $this->field_id . '[custom_class]',
				'class'       => $this->default_class . ' ur-settings-custom-class',
				'type'        => 'text',
				'required'    => false,
				'default'     => '',
				'placeholder' => __( 'Custom Class', 'user-registration-file-upload' ),
				'tip'         => __( 'Class name to embed in this field.', 'user-registration-file-upload' ),
			),
			'valid_file_type' => array(
				'type'     => 'select',
				'label'    => __( 'Valid File Types', 'user-registration-file-upload' ),
				'multiple' => true,
				'data-id'  => $this->field_id . '_valid_file_type',
				'name'     => $this->field_id . '[valid_file_type]',
				'class'    => $this->default_class,
				'required' => true,
				'default'  => array(),
				'options'  => urfu_get_valid_file_type(),
				'tip'      => __( 'Choose valid file types allowed for uploads', 'user-registration-file-upload' ),
			),
			'max_upload_size' => array(
				'type'        => 'text',
				'label'       => __( 'Max File Size Allowed', 'user-registration-file-upload' ),
				'data-id'     => $this->field_id . '_max_upload_size',
				'name'        => $this->field_id . '[max_upload_size]',
				'class'       => $this->default_class,
				'required'    => true,
				'placeholder' => '1024',
				'default'     => '',
				'tip'         => sprintf( esc_html__( 'Enter the max file size, in Kb, to allow. If left blank, the value defaults to the maximum size the server allows which is %s.', 'user-registration-file-upload' ), ( wp_max_upload_size() / 1024 ) . ' Kb' ),
			),

		);

		$this->render_html( $fields );
	}
}

return new UR_Setting_File();
