/**
 * UserRegistrationProfileConnectAdmin JS
 * global user_registration_pro_admin_script_data
 * global user_registration_profile_connect_params
 */
jQuery(function ($) {
	var UR_PROFILE_CONNECT = {
		init: function () {
			this.initialize_external_fields_mapping();
		},
		initialize_external_fields_mapping: function () {
			$(document).ready(function () {
				UR_PROFILE_CONNECT.hide_show_external_fields_mapping();
				$(document).on(
					"change",
					"#user_registration_profile_connect_settings_db_table",
					function () {
						UR_PROFILE_CONNECT.get_columns_for_selected_table();
					}
				);
				$(document).on(
					"change",
					"#user_registration_profile_connect_settings_form",
					function () {
						var $selected_form = $(
							"#user_registration_profile_connect_settings_form"
						).val();

						if (0 != $selected_form) {
							$(
								"#user_registration_profile_connect_settings_form"
							)
								.parent()
								.parent()
								.find("th")
								.append('<span class="ur-spinner"></span>');
						}
						UR_PROFILE_CONNECT.hide_show_external_fields_mapping();
						UR_PROFILE_CONNECT.get_fields_list("load");
					}
				);
				$(document).on(
					"change",
					"#user_registration_profile_connect_settings_table_selection",
					function () {
						UR_PROFILE_CONNECT.hide_show_external_tables();
					}
				);
				var ur_profile_connect_form_fields =
					user_registration_profile_connect_params.ur_profile_connect_form_fields;

				$(document).on(
					"click",
					".ur-profile-connect-external-field-map-group .add",
					function () {
						var $data_key = $(this)
							.closest(".ur-profile-connect-field-mapping-box")
							.attr("data-last-key");
						$data_key++;

						var $output =
							'<li class="ur-profile-connect-external-field-map-group" data-key="' +
							$data_key +
							'">';
						$output +=
							'<div class="ur-profile-connect-external-field-map-form-group">';

						$output +=
							'<input name="user_registration_form_value[' +
							$data_key +
							']" class="ur_profile_connect_external_field_name" type="text" placeholder="Enter Field Key" />';
						$output += "</div>";
						$output +=
							'<div class="ur-profile-connect-operator"> <i class="dashicons dashicons-arrow-right-alt"></i> </div>';
						$output += '<div class="ur-profile-connect-value">';
						$output +=
							'<select class="ur-profile-connect-fields ur-profile-connect-field-map-select" name="ur_profile_connect_external_map_form_fields[' +
							$data_key +
							']">';

						$output +=
							'<option value="">-- Select Form Field --</option>';
						$output += "</select></div>";
						$output +=
							'<div class="ur-profile-connect-mapping-action">';
						$output += '<span class="add">';
						$output += '<i class="dashicons dashicons-plus"></i>';
						$output += "</span>";
						$output += '<span class="remove">';
						$output += '<i class="dashicons dashicons-minus"></i>';
						$output += "</span>";
						$output += "</div></li>";

						$(this)
							.closest(".ur-profile-connect-field-mapping-box")
							.append($output);

						$(this)
							.closest(".ur-profile-connect-field-mapping-box")
							.attr("data-last-key", $data_key);
						UR_PROFILE_CONNECT.get_fields_list("add", $data_key);
					}
				);

				$(document).on(
					"click",
					".ur-profile-connect-external-field-map-group .remove",
					function () {
						var row_count = $(
							".ur-profile-connect-field-mapping-box"
						).find(
							".ur-profile-connect-external-field-map-group"
						).length;
						if (row_count > 1) {
							$(this).parent().parent().remove();
						}
					}
				);
			});
		},
		/**
		 * Get Columns List for selected Database Table.
		 */
		get_columns_for_selected_table: function () {
			var $selected_table = $(
				"#user_registration_profile_connect_settings_db_table"
			).val();
			var data = {
				action: "user_registration_pro_get_db_columns_by_table",
				security:
					user_registration_pro_admin_script_data.ur_pro_get_db_columns_by_table,
				table: $selected_table,
			};

			$("#user_registration_profile_connect_settings_user_id_db_column")
				.parent()
				.parent()
				.find("th")
				.append('<span class="ur-spinner"></span>');
			$("#user_registration_profile_connect_settings_field_key_db_column")
				.parent()
				.parent()
				.find("th")
				.append('<span class="ur-spinner"></span>');
			$(
				"#user_registration_profile_connect_settings_field_value_db_column"
			)
				.parent()
				.parent()
				.find("th")
				.append('<span class="ur-spinner"></span>');

			$.ajax({
				url: user_registration_pro_admin_script_data.ajax_url,
				data: data,
				type: "POST",
				success: function (response) {
					if (response.success) {
						if ("undefined" != typeof response.data.columns) {
							var columns_list = JSON.parse(
								response.data.columns
							);

							$(
								"#user_registration_profile_connect_settings_user_id_db_column option"
							).remove();
							$(
								"#user_registration_profile_connect_settings_field_key_db_column option"
							).remove();
							$(
								"#user_registration_profile_connect_settings_field_value_db_column option"
							).remove();

							$(
								"#user_registration_profile_connect_settings_user_id_db_column"
							).append(
								$("<option>", {
									value: "",
									text: "-- Select Column for User ID --",
								})
							);
							$(
								"#user_registration_profile_connect_settings_field_key_db_column"
							).append(
								$("<option>", {
									value: "",
									text: "-- Select Column for Field Key --",
								})
							);
							$(
								"#user_registration_profile_connect_settings_field_value_db_column"
							).append(
								$("<option>", {
									value: "",
									text: "-- Select Column for Field Value --  ",
								})
							);

							var $output_options = "";
							$.each(columns_list, function (key, value) {
								$output_options +=
									'<option value="' +
									value +
									'">' +
									value +
									"</option>";
								$(
									"#user_registration_profile_connect_settings_user_id_db_column"
								).append(
									$("<option>", { value: value, text: value })
								);
								$(
									"#user_registration_profile_connect_settings_field_key_db_column"
								).append(
									$("<option>", { value: value, text: value })
								);
								$(
									"#user_registration_profile_connect_settings_field_value_db_column"
								).append(
									$("<option>", { value: value, text: value })
								);
							});
						}
					}
					$(".ur-spinner").remove();
				},
			});
		},
		/**
		 * Hide Show External Tables Lists
		 */
		hide_show_external_tables: function () {
			var $table_selection = $(
				"#user_registration_profile_connect_settings_table_selection"
			).val();
			if ("usermeta_table" == $table_selection) {
				$("#user_registration_profile_connect_settings_db_table")
					.parent()
					.parent()
					.hide();
				$(
					"#user_registration_profile_connect_settings_user_id_db_column"
				)
					.parent()
					.parent()
					.hide();
				$(
					"#user_registration_profile_connect_settings_field_key_db_column"
				)
					.parent()
					.parent()
					.hide();
				$(
					"#user_registration_profile_connect_settings_field_value_db_column"
				)
					.parent()
					.parent()
					.hide();
			} else {
				$("#user_registration_profile_connect_settings_db_table")
					.parent()
					.parent()
					.show();
				$(
					"#user_registration_profile_connect_settings_user_id_db_column"
				)
					.parent()
					.parent()
					.show();
				$(
					"#user_registration_profile_connect_settings_field_key_db_column"
				)
					.parent()
					.parent()
					.show();
				$(
					"#user_registration_profile_connect_settings_field_value_db_column"
				)
					.parent()
					.parent()
					.show();
			}
		},
		/**
		 * Hide Show External Field Mapping Section when enabled disabled.
		 */
		hide_show_external_fields_mapping: function () {
			var $selected_form = $(
				"#user_registration_profile_connect_settings_form"
			).val();

			if (0 != $selected_form) {
				$(
					".user_registration_profile_connect_external_field_mapping_wrapper"
				).show();

				$("#user_registration_profile_connect_settings_table_selection")
					.parent()
					.parent()
					.show();

				UR_PROFILE_CONNECT.hide_show_external_tables();
			} else {
				$(
					".user_registration_profile_connect_external_field_mapping_wrapper"
				).hide();

				$("#user_registration_profile_connect_settings_table_selection")
					.parent()
					.parent()
					.hide();
				$("#user_registration_profile_connect_settings_db_table")
					.parent()
					.parent()
					.hide();
				$(
					"#user_registration_profile_connect_settings_user_id_db_column"
				)
					.parent()
					.parent()
					.hide();
				$(
					"#user_registration_profile_connect_settings_field_key_db_column"
				)
					.parent()
					.parent()
					.hide();
				$(
					"#user_registration_profile_connect_settings_field_value_db_column"
				)
					.parent()
					.parent()
					.hide();
			}
		},
		/**
		 * Get list of fields wrapped in `option` tag.
		 * Warning: The output will NOT be wrapped with the `select` tag.
		 */
		get_fields_list: function ($type, $data_key) {
			var data = {
				action: "user_registration_pro_get_form_fields_list_by_form_id",
				security:
					user_registration_pro_admin_script_data.ur_pro_get_form_fields_by_form_id,
				form_id: $(
					"#user_registration_profile_connect_settings_form"
				).val(),
			};
			$.ajax({
				url: user_registration_pro_admin_script_data.ajax_url,
				data: data,
				type: "POST",
				success: function (response) {
					if (response.success) {
						if (
							"undefined" != typeof response.data.form_field_list
						) {
							if ("add" === $type) {
								var options =
									'<option value="">-- Select Form Field --</option>';
								var $form_field_list = JSON.parse(
									response.data.form_field_list
								);
								$.each($form_field_list, function (key, value) {
									options +=
										'<option value="' +
										key +
										'">' +
										value +
										"</option>";
								});
								$(".ur-spinner").remove();
								$('[data-key="' + $data_key + '"]')
									.find(
										".ur-profile-connect-field-map-select option"
									)
									.remove();

								$('[data-key="' + $data_key + '"]')
									.find(
										".ur-profile-connect-field-map-select"
									)
									.append(options);
							} else {
								$(
									".ur-profile-connect-field-map-select option"
								).remove();

								$(".ur-profile-connect-field-map-select").each(
									function () {
										var options =
											'<option value="">-- Select Form Field --</option>';
										var $form_field_list = JSON.parse(
											response.data.form_field_list
										);
										$.each(
											$form_field_list,
											function (key, value) {
												options +=
													'<option value="' +
													key +
													'">' +
													value +
													"</option>";
											}
										);
										$(".ur-spinner").remove();
										$(this).append(options);
									}
								);
							}
						}
					}
				},
			});
		},
	};

	UR_PROFILE_CONNECT.init();
});
