<?php
/**
 * Blocks controller class.
 *
 * @since xx.xx.xx
 *
 * @package  UserRegistrationWooCommerce/Classes
 */

defined( 'ABSPATH' ) || exit;

/**
 * UR_AddonsClass
 */
class URWC_SYNC_FIELDS_BLOCK {

	/**
	 * Endpoint namespace.
	 *
	 * @var string
	 */
	protected $namespace = 'urwc';

	/**
	 * Route base.
	 *
	 * @var string
	 */
	protected $rest_base = 'blocks';

	/**
	 * Register routes.
	 *
	 * @since xx.xx.xx
	 *
	 * @return void
	 */
	public function register_routes() {
		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/get-sync-fields-details',
			array(
				'methods'             => 'GET',
				'callback'            => array( __CLASS__, 'get_sync_fields_details' ),
				'permission_callback' => array( __CLASS__, 'check_admin_permissions' ),
			)
		);
	}

	/**
	 * Get Sync field details.
	 *
	 * @since xx.xx.xx
	 *
	 * @return array Addon lists.
	 */
	public static function get_sync_fields_details($request) {
		$form_lists = ur_get_all_user_registration_form();
		$requested_form_id = $request->get_param('formId');
		$checkout_form_id        = !empty($requested_form_id) ? $requested_form_id : get_option( 'user_registration_woocommerce_settings_form', 0 );
		$checkout_form_fields_list = get_option( 'user_registration_woocommerce_checkout_fields', array() );
		$checkout_form_fields    = isset($checkout_form_fields_list['form-'.$checkout_form_id]) ? $checkout_form_fields_list['form-'.$checkout_form_id] : array();
		$profile = urwc_get_form_fields( $checkout_form_id );
		$checkout_form_fields_label = array();

		$exclude_fields = urwc_checkout_unsupported_fields_list();

		if ( $profile ) {
			foreach ( $profile as $field_name => $field_details ) {
				if ( in_array( $field_details['type'], $exclude_fields, true ) ) {
					unset($profile[$field_name]);
				}
			}
		}

		return new \WP_REST_Response(
			array(
				'success'    => true,
				'form_lists' => $form_lists,
				'form_fields' => $profile,
				'selected_form_fields'=> $checkout_form_fields
			),
			200
		);
	}
	/**
	 * Check if a given request has access to update a setting
	 *
	 * @param WP_REST_Request $request Full data about the request.
	 * @return WP_Error|bool
	 */
	public static function check_admin_permissions( $request ) {
		return current_user_can( 'manage_options' );
	}
}
