<?php
use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;

/**
 * Class for integrating with WooCommerce Blocks
 */
class URWC_Blocks_Integration implements IntegrationInterface {

	/**
	 * The name of the integration.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'user-registration-woocommerce';
	}

	/**
	 * When called invokes any initialization/setup for the integration.
	 */
	public function initialize() {
		require_once __DIR__ . '/class-urwc-extend-store-endpoint.php';
		$this->register_urwc_block_frontend_scripts();
	}

	/**
	 * Returns an array of script handles to enqueue in the frontend context.
	 *
	 * @return string[]
	 */
	public function get_script_handles() {
		return array( 'urwc-block-frontend' );
	}

	/**
	 * Returns an array of script handles to enqueue in the editor context.
	 *
	 * @return string[]
	 */
	public function get_editor_script_handles() {
		return array();
	}

	/**
	 * An array of key, value pairs of data made available to the block on the client side.
	 *
	 * @return array
	 */
	public function get_script_data() {
		return array();
	}

	/**
	 * Register Block editor styles.
	 */
	public function register_urwc_block_editor_styles() {
		$style_path = '/build/style-urwc-block.css';

		$style_url = plugins_url( $style_path, __FILE__ );
		wp_enqueue_style(
			'urwc-block',
			$style_url,
			array(),
			$this->get_file_version( $style_path )
		);
	}

	/**
	 * Register Block editor scripts.
	 */
	public function register_urwc_block_editor_scripts() {
		$script_path       = '/build/urwc-block.js';
		$script_url        = plugins_url( $script_path, __FILE__ );
		$script_asset_path = __DIR__ . '/build/urwc-block.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_asset_path ),
			);

		wp_register_script(
			'urwc-block-editor',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		wp_set_script_translations(
			'urwc-block-editor',
			'urwc',
			__DIR__ . '/languages'
		);
	}

	/**
	 * Register Block frontend scripts.
	 */
	public function register_urwc_block_frontend_scripts() {
		$script_asset_path = URWC()->plugin_url() . '/chunks/urwc-block-frontend.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_asset_path ),
			);

		wp_register_script(
			'urwc-block-frontend',
			URWC()->plugin_url() . '/chunks/urwc-block-frontend.js',
			array_merge( array( 'jquery', 'selectWoo', 'select2' ), $script_asset['dependencies'], wp_script_is( 'user-registration-advanced-fields-frontend', 'registered' ) ? array( 'user-registration-advanced-fields-frontend' ) : array() ),
			$script_asset['version'],
			true
		);
	}

	/**
	 * Get the file modified time as a cache buster if we're in dev mode.
	 *
	 * @param string $file Local path to the file.
	 * @return string The cache buster value to use for the given file.
	 */
	protected function get_file_version( $file ) {
		if ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG && file_exists( $file ) ) {
			return filemtime( $file );
		}
		return URWC_VERSION;
	}
}
