<?php
/**
 * Course bundle product type for WooCommerce.
 *
 * @since 2.14.0
 * @package Masteriyo\Addons\CourseBundle
 */

namespace Masteriyo\Addons\CourseBundle;

use Masteriyo\Addons\WcIntegration\CourseProduct;

class CourseBundleProduct extends CourseProduct {

	/**
	 * Get internal type.
	 *
	 * @since 2.14.0
	 *
	 * @return string
	 */
	public function get_type() {
		return 'mto_course_bundle';
	}

	/**
	 * Check if a product is sold individually (no quantities).
	 *
	 * @since 2.14.0
	 *
	 * @return bool
	 */
	public function is_sold_individually() {
		return apply_filters( 'woocommerce_is_sold_individually', true, $this );
	}

	/**
	 * Return if product manage stock.
	 *
	 * @since  2.14.0
	 * @param  string $context What the value is for. Valid values are view and edit.
	 * @return boolean
	 */
	public function get_manage_stock( $context = 'view' ) {
		return false;
	}

	/**
	 * Get virtual.
	 *
	 * @since  2.14.0
	 * @param  string $context What the value is for. Valid values are view and edit.
	 * @return bool
	 */
	public function get_virtual( $context = 'view' ) {
		return true;
	}

	/**
	 * Get downloadable.
	 *
	 * @since  2.14.0
	 * @param  string $context What the value is for. Valid values are view and edit.
	 * @return bool
	 */
	public function get_downloadable( $context = 'view' ) {
		return true;
	}
}
