<?php

/**
 * The Template for displaying video playlist popup modal for course lesson.
 *
 * @since 2.6.7
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Fires before rendering video playlist popup modal.
 *
 * @since 2.6.7
 */
do_action( 'masteriyo_before_course_preview_video_playlist_popup_modal' );

?>
<div id="masteriyo-course-preview-video-playlist-modal" class="masteriyo-course-preview-modal">
	<div class="masteriyo-course-preview-modal-content">
		<div class="masteriyo-course-preview__header">
			<div class="masteriyo-course-preview__header-title">
				<h5 class="masteriyo-course-preview__header-title-sub-title"></h5>
				<h2 class="masteriyo-course-preview__header-title-main-title"></h2>
			</div>
			<span class="close">×</span>
		</div>
		<div id="masteriyo-course-preview-video-player-container" class="masteriyo-course-preview-video-player-container">
			<iframe class="masteriyo-course-preview-video-player" src="" frameborder="0" allowfullscreen width="100%" allow=autoplay></iframe>
			<video class="masteriyo-course-preview-video-player" src="" controls="true" autoplay="true" width="100%"></video>
		</div>
		<div class="masteriyo-course-preview-playlist">
			<h2 class="masteriyo-course-preview-title"><?php esc_html_e( 'Free Lesson Videos:', 'learning-management-system' ); ?></h2>
			<!-- video_playlist_items -->
			<div class="masteriyo-course-preview-playlist__wrapper">
				<?php if ( count( $video_playlist_items ) ) : ?>
					<?php foreach ( $video_playlist_items as $video_playlist_item ) : ?>
						<div
							class="masteriyo-course-preview-playlist-item"
							data-video-src="<?php echo esc_url_raw( $video_playlist_item['video_url'] ); ?>"
							data-iframe="<?php echo esc_attr( $video_playlist_item['is_iframe'] ); ?>"
							data-lesson-id="<?php echo esc_attr( $video_playlist_item['id'] ); ?>"
							data-source="<?php echo esc_attr( $video_playlist_item['video_source'] ); ?>"
						>
							<div class="masteriyo-course-preview-preview-thumbnail">
								<img
									src="<?php echo esc_url_raw( $video_playlist_item['thumbnail_url'] ); ?>"
									alt="<?php echo esc_attr( 'Thumbnail' ); ?>" class="masteriyo-course-preview-preview-image"
								>
								<div class="masteriyo-course-preview-play-icon">
									<?php masteriyo_get_svg( 'play', true ); ?>
								</div>
							</div>
							<div class="masteriyo-course-preview-preview-details">
								<div class="masteriyo-course-preview-preview-title">
									<?php echo esc_html( $video_playlist_item['lesson_name'] ); ?>
								</div>
								<div class="masteriyo-course-preview-preview-duration">
									<?php echo esc_html( $video_playlist_item['video_length'] ); ?>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				<?php endif ?>
			</div>
		</div>
	</div>
</div>
<?php

/**
 * Fires after rendering video playlist popup modal.
 *
 * @since 2.6.7
 */
do_action( 'masteriyo_after_course_preview_video_playlist_popup_modal' );
