<?php
/**
 * Mailchimp integration service provider.
 *
 * @since 2.7.1
 */

namespace Masteriyo\Addons\MailchimpIntegration\Providers;

defined( 'ABSPATH' ) || exit;

use League\Container\ServiceProvider\AbstractServiceProvider;
use Masteriyo\Addons\MailchimpIntegration\MailchimpIntegrationAddon;
use Masteriyo\Addons\MailchimpIntegration\RestApi\Controllers\Version1\MailchimpIntegrationController;

class MailchimpIntegrationServiceProvider extends AbstractServiceProvider {
	/**
	 * The provided array is a way to let the container
	 * know that a service is provided by this service
	 * provider. Every service that is registered via
	 * this service provider must have an alias added
	 * to this array or it will be ignored
	 *
	 * @since 2.7.1
	 *
	 * @var array
	 */
	protected $provides = array(
		'mailchimp_integration',
		'mailchimp_integration.rest',
		'mto-mailchimp_integration',
		'mto-mailchimp_integration.rest',
		'addons.mailchimp-integration',
		MailchimpIntegrationAddon::class,
	);

	/**
	 * This is where the magic happens, within the method you can
	 * access the container and register or retrieve anything
	 * that you need to, but remember, every alias registered
	 * within this method must be declared in the `$provides` array.
	 *
	 * @since 2.7.1
	*/
	public function register() {

		$this->getContainer()->add( 'mailchimp_integration.rest', MailchimpIntegrationController::class )
			->addArgument( 'permission' );

		$this->getContainer()->add( MailchimpIntegrationController::class )
			->addArgument( 'permission' );

		// Register based on post type.
		$this->getContainer()->add( 'mto-mailchimp_integration.rest', MailchimpIntegrationController::class )
			->addArgument( 'permission' );

		$this->getContainer()->add( 'addons.mailchimp-integration', MailchimpIntegrationAddon::class, true );
	}
}
