<?php
/**
 * Addon Name: Mailchimp Integration
 * Addon URL: https://masteriyo.com/wordpress-lms/
 * Description: Seamlessly integrate Mailchimp with Masteriyo LMS for efficient and automated email marketing within your learning management system.
 * Author: Masteriyo
 * Author URL: https://masteriyo.com
 * Addon Type: integration
 * Plan: Starter
 */


use Masteriyo\Pro\Addons;


define( 'MASTERIYO_MAILCHIMP_INTEGRATION_SLUG', 'mailchimp-integration' );
define( 'MASTERIYO_MAILCHIMP_INTEGRATION_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_MAILCHIMP_INTEGRATION_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_MAILCHIMP_INTEGRATION_DIR', dirname( __FILE__ ) );

//Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_MAILCHIMP_INTEGRATION_SLUG ) ) {
	return;
}

add_filter(
	'masteriyo_service_providers',
	function( $providers ) {
		return array_merge( $providers, require_once dirname( __FILE__ ) . '/config/providers.php' );
	}
);

//Initiate mailchimp integration addon.
add_action(
	'masteriyo_before_init',
	function() {
		masteriyo( 'addons.mailchimp-integration' )->init();
	}
);
