<?php
/**
 * Addon Name: Public Profile
 * Addon URI: https://masteriyo.com/wordpress-lms/
 * Description: The "Public Profile" addon by Masteriyo provides instructors or students with a public profile page visible to others.
 * Author: Masteriyo
 * Author URI: https://masteriyo.com
 * Addon Type: Feature
 * Plan: Starter
 */

use Masteriyo\Pro\Addons;
use Masteriyo\Addons\PublicProfile\PublicProfileAddon;

define( 'MASTERIYO_PUBLIC_PROFILE_ADDON_FILE', __FILE__ );
define( 'MASTERIYO_PUBLIC_PROFILE_ADDON_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_PUBLIC_PROFILE_ADDON_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_PUBLIC_PROFILE_ADDON_SLUG', 'public-profile' );
define( 'MASTERIYO_PUBLIC_PROFILE_ADDON_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_PUBLIC_PROFILE_ADDON_ASSETS_URL', plugins_url( 'assets', MASTERIYO_PUBLIC_PROFILE_ADDON_FILE ) );




// Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_PUBLIC_PROFILE_ADDON_SLUG ) ) {
	return;
}

require_once dirname( __FILE__ ) . '/helper/public-profile.php';
require_once dirname( __FILE__ ) . '/template-functions.php';
require_once dirname( __FILE__ ) . '/template-hooks.php';

// Initiate public profile addon.
PublicProfileAddon::instance()->init();
