<?php
/**
 * Masteriyo Social Login Integration setup.
 *
 * @package Masteriyo\SocialLogin
 *
 * @since 2.7.0
 */

namespace Masteriyo\Addons\SocialLogin;

use Masteriyo\Addons\SocialLogin\GoogleProcessLogin;
use Masteriyo\Addons\SocialLogin\Setting;
use Masteriyo\Addons\SocialLogin\FacebookProcessLogin as SocialLoginFacebookProcessLogin;
use Masteriyo\Constants;

defined( 'ABSPATH' ) || exit;

/**
 * Main Masteriyo SocialLogin class.
 *
 * @class Masteriyo\Addons\SocialLogin
 * @since 2.7.0 Renamed to SocialLoginAddon
 */

class SocialLoginAddon {

	/**
	 * Instance of Setting class.
	 *
	 * @since 2.7.0
	 * @var Masteriyo\Addons\SocialLogin\Setting
	 */
	public $setting = null;

	/**
	 * The single instance of the class.
	 *
	 * @since 2.7.0
	 *
	 * @var \Masteriyo\Addons\\SocialLogin\SocialLoginAddon|null
	 */
	protected static $instance = null;

	/**
	 * Constructor.
	 *
	 * @since 2.7.0
	 */
	protected function __construct() {}

	/**
	 * Get class instance.
	 *
	 * @since 2.7.0
	 *
	 * @return \Masteriyo\Addons\SocialLogin\SocialLoginAddon Instance.
	 */
	final public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Prevent cloning.
	 *
	 * @since 2.7.0
	 */
	public function __clone() {}

	/**
	 * Prevent unserializing.
	 *
	 * @since 2.7.0
	 */
	public function __wakeup() {}

	/**
	 * Initialize module.
	 *
	 * @since 2.7.0
	 *
	 */
	public function init() {
		$this->setting = new Setting();
		$this->setting->init();
		GoogleProcessLogin::init();
		SocialLoginFacebookProcessLogin::init();
		$this->init_hooks();
	}

	/**
	 * Init hooks.
	 *
	 * @since 2.7.0
	 */
	public function init_hooks() {
		add_action( 'masteriyo_login_form_after_submit_button', array( $this, 'social_login_oauth_url' ) );
	}

	/**
	 * Social Login buttons and oauth urls.
	 *
	 * @since 2.7.0
	 */
	public function social_login_oauth_url() {
		$url   = masteriyo_get_current_url();
		$state = '';

		if ( str_contains( $url, 'instructor' ) ) {
			$state = 'masteriyo_instructor';
		}
		if ( str_contains( $url, 'student' ) ) {
			$state = 'masteriyo_student';
		} else {
			$state = 'masteriyo_student';
		}
		$google       = $this->setting->get( 'google' );
		$facebook     = $this->setting->get( 'facebook' );
		$facebook_url = masteriyo_get_social_login_redirect_url( 'masteriyo-facebook-login' );
		$google_url   = masteriyo_get_social_login_redirect_url( 'masteriyo-google-login' );

		/**
		 * Displays the templates for buttons in the login page based on option enabled in the settings.
		 *
		 * @since 2.7.0
		 */
		if ( $this->setting->get( 'google.enable' ) || $this->setting->get( 'facebook.enable' ) ) {
			?>
			<br/>
			<div style="text-align:center"><?php esc_html_e( 'Or', 'learning-management-system' ); ?></div> 
			<?php
		}

		if ( $this->setting->get( 'google.enable' ) ) {
			include_once Constants::get( 'MASTERIYO_SOCIAL_LOGIN_TEMPLATES' ) . '/google-sign-in-buttons.php';
		}

		if ( $this->setting->get( 'facebook.enable' ) ) {
			include_once Constants::get( 'MASTERIYO_SOCIAL_LOGIN_TEMPLATES' ) . '/facebook-sign-in-button.php';
		}
		?>

		<?php
	}

}



