<?php
/**
 * Addon Name: Social Login
 * Addon URL: https://masteriyo.com/wordpress-lms/
 * Description: Social login via Facebook and Google adds a layer of convenience by allowing users to authenticate with their existing social media accounts, streamlining the login process.
 * Author: Masteriyo
 * Author URL: https://masteriyo.com
 * Version: 2.7.0
 * Addon Type: Feature
 * Plan:Starter
 */

use Masteriyo\Pro\Addons;
use Masteriyo\Addons\SocialLogin\SocialLoginAddon;

define( 'MASTERIYO_SOCIAL_LOGIN_ADDON_FILE', __FILE__ );
define( 'MASTERIYO_SOCIAL_LOGIN_ADDON_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_SOCIAL_LOGIN_ADDON_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_SOCIAL_LOGIN_ASSETS', dirname( __FILE__ ) . '/assets' );
define( 'MASTERIYO_SOCIAL_LOGIN_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_SOCIAL_LOGIN_ADDON_SLUG', 'social-login' );




// Bail early if the addon is not active.
if ( ! ( ( new Addons() )->is_active( MASTERIYO_SOCIAL_LOGIN_ADDON_SLUG ) ) ) {
	return;
}

require_once dirname( __FILE__ ) . '/helper/social-login.php';

// Initialize wc integration addon.
SocialLoginAddon::instance()->init();
