<?php
/**
 * Twitter.
 *
 * @package Masteriyo\SocialShare
 *
 * @since 2.5.27
 */

namespace Masteriyo\Addons\SocialShare\SocialShare;

use Masteriyo\Addons\SocialShare\Setting;

defined( 'ABSPATH' ) || exit;

/**
 * Twitter class.
 *
 */
class Twitter {

	/**
	 * Name for the Twitter.
	 *
	 * @var string
	 *
	 * @since 2.5.27
	 */
	protected $name = 'twitter';

	/**
	 * Twitter share URL.
	 *
	 * @return string Twitter share URL.
	 *
	 * @since 2.5.27
	 */
	public function share_url( $url ) {
		return 'https://twitter.com/intent/tweet?url=' . rawurlencode( $url ) . '&text=';
	}

	/**
	 * Get the name for Twitter share button.
	 *
	 * @return string Name for Twitter share button.
	 *
	 * @since 2.5.27
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Get the title for Twitter share button.
	 *
	 * @return string Title for Twitter share button.
	 *
	 * @since 2.5.27
	 */
	public function get_title() {
		return __( 'Share on Twitter', 'learning-management-system' );
	}

	/**
	 * Checks whether the Twitter is enabled or not.
	 *
	 * @return bool Returns true if enabled, otherwise false.
	 *
	 * @since 2.5.27
	 */
	public function is_enabled() {
		return Setting::get( 'sharing_services.twitter' );
	}
}
