<?php
/**
 * Social share class.
 *
 * @package Masteriyo\Addons\SocialShare
 *
 * @since 2.5.27
 */

namespace Masteriyo\Addons\SocialShare;

use Masteriyo\Addons\SocialShare\SocialShare\Twitter;
use Masteriyo\Addons\SocialShare\SocialShare\Facebook;
use Masteriyo\Addons\SocialShare\SocialShare\LinkedIn;

defined( 'ABSPATH' ) || exit;

/**
 * SocialShares class.
 */
class SocialShares {

	/**
	 * Return instances of social shares.
	 *
	 * @since 2.5.27
	 *
	 * @return array Array of instances of social shares.
	 */
	public static function all() {

		/**
		 * Filters social shares.
		 *
		 * @since 2.5.27
		 *
		 * @param array $social_shares Array of social shares to be filtered.
		 */
		$social_shares = apply_filters(
			'masteriyo_social_shares',
			array(
				Facebook::class,
				Twitter::class,
				LinkedIn::class,
			)
		);

		// Filter only the classes that exist.
		$social_shares = array_filter(
			$social_shares,
			function( $social_share ) {
				return class_exists( $social_share );
			}
		);

		// Create instances of each class.
		$instances = array_map(
			function( $social_share ) {
				return new $social_share();
			},
			$social_shares
		);

		// Filter only the enabled instances.
		$instances = array_filter(
			$instances,
			function( $instance ) {
				return $instance->is_enabled();
			}
		);

		return $instances;
	}
}
