<?php
/**
 * Addon Name: Social Share
 * Addon URI: https://masteriyo.com/wordpress-lms/
 * Description: The "Social Share" addon by Masteriyo adds social sharing functionality to the single course page.
 * Author: Masteriyo
 * Author URI: https://masteriyo.com
 * Addon Type: feature
 * Plan: Starter
 */

use Masteriyo\Addons\SocialShare\SocialShareAddon;
use Masteriyo\Pro\Addons;

define( 'MASTERIYO_SOCIAL_SHARE_FILE', __FILE__ );
define( 'MASTERIYO_SOCIAL_SHARE_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_SOCIAL_SHARE_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_SOCIAL_SHARE_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_SOCIAL_SHARE_SLUG', 'social-share' );

// Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_SOCIAL_SHARE_SLUG ) ) {
	return;
}

/**
 * Include service providers for Social Share.
 */
add_filter(
	'masteriyo_service_providers',
	function( $providers ) {
		return array_merge( $providers, require_once dirname( __FILE__ ) . '/config/providers.php' );
	}
);

// Initiate social share addon.
SocialShareAddon::instance()->init();
