<?php
/**
 * Enums for Login Locations.
 *
 * This file defines constants for different login locations used in the Masteriyo Two-Factor Authentication feature.
 *
 * @since 2.7.0
 *
 * @package Masteriyo\Addons\TwoFactorAuthentication\Enums
 */

namespace Masteriyo\Addons\TwoFactorAuthentication\Enums;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Class LoginLocations
 *
 * Defines the constants for identifying different login locations.
 *
 * @since 2.7.0
 */
class LoginLocations {
	/**
	 * Represents the option for both Masteriyo and WordPress login locations.
	 *
	 * @since 2.7.0
	 */
	const LOCATION_BOTH = 'both';

	/**
	 * Represents the Masteriyo specific login location.
	 *
	 * @since 2.7.0
	 */
	const LOCATION_MASTERIYO = 'masteriyo_login';

	/**
	 * Represents the WordPress specific login location.
	 *
	 * @since 2.7.0
	 */
	const LOCATION_WP = 'wp_login';

	/**
	 * Return an array of all defined login location constants.
	 *
	 * This function returns an array containing all the constants for different login locations.
	 * A filter is applied to allow for further extensibility.
	 *
	 * @since 2.7.0
	 *
	 * @return array An array of login location constants.
	 */
	public static function all() {
		return array_unique(
			/**
			 * Filter for modifying the login location list.
			 *
			 * This allows for the modification of the list of login locations through a WordPress filter.
			 *
			 * @since 2.7.0
			 *
			 * @param string[] $locations An array of login location constants.
			 */
			apply_filters(
				'masteriyo_two_factor_authentication_login_locations',
				array(
					self::LOCATION_BOTH,
					self::LOCATION_MASTERIYO,
					self::LOCATION_WP,
				)
			)
		);
	}
}
