<?php
/**
 * Store global two-factor authentication options.
 *
 * @since 2.7.0
 *
 * @package \Masteriyo\Addons\TwoFactorAuthentication
 */

namespace Masteriyo\Addons\TwoFactorAuthentication;

class Setting {

	/**
	 * Global option name.
	 *
	 * @since 2.7.0
	 */
	const OPTION_NAME = 'masteriyo_two_factor_authentication_settings';

	/**
	 * Data.
	 *
	 * @since 2.7.0
	 *
	 * @var array
	 */
	protected static $data = array(
		'method'                  => 'email',
		'location'                => 'both',
		'opt_length'              => 6,
		'opt_expiration'          => 30 * 60,
		'opt_resend_interval'     => 2 * 60,
		'opt_resend_max_attempts' => 10,
	);

	/**
	 * Read the settings.
	 *
	 * @since 2.7.0
	 */
	protected static function read() {
		$settings   = get_option( self::OPTION_NAME, self::$data );
		self::$data = masteriyo_parse_args( $settings, self::$data );

		return self::$data;
	}

	/**
	 * Return all the settings.
	 *
	 * @since 2.7.0
	 *
	 * @return mixed
	 */
	public static function all() {
		return self::read();
	}

	/**
	 * Return global two-factor authentication field value.
	 *
	 * @since 2.7.0
	 *
	 * @param string $key
	 *
	 * @return string|array
	 */
	public static function get( $key ) {
		self::read();

		return masteriyo_array_get( self::$data, $key, null );
	}

	/**
	 * Set global two-factor authentication field.
	 *
	 * @since 2.7.0
	 *
	 * @param string $key Setting key.
	 * @param mixed $value Setting value.
	 */
	public static function set( $key, $value ) {
		masteriyo_array_set( self::$data, $key, $value );
		self::save();
	}

	/**
	 * Set multiple settings.
	 *
	 * @since 2.7.0
	 *
	 * @param array $args
	 */
	public static function set_props( $args ) {
		self::$data = masteriyo_parse_args( $args, self::$data );
	}

	/**
	 * Save the settings.
	 *
	 * @since 2.7.0
	 */
	public static function save() {
		update_option( self::OPTION_NAME, self::$data );
	}
}
