<?php
/**
 * Addon Name: Two-Factor Authentication
 * Addon URI: https://masteriyo.com/wordpress-lms/
 * Description: Two-factor authentication enhances security by requiring users to verify their identity through a one-time password (OTP) sent to their email, providing an additional layer of protection beyond passwords.
 * Author: Masteriyo
 * Author URI: https://masteriyo.com
 * Addon Type: Feature
 * Plan: Starter
 */

use Masteriyo\Pro\Addons;
use Masteriyo\Addons\TwoFactorAuthentication\TwoFactorAuthenticationAddon;

define( 'MASTERIYO_TWO_FACTOR_AUTHENTICATION_ADDON_FILE', __FILE__ );
define( 'MASTERIYO_TWO_FACTOR_AUTHENTICATION_ADDON_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_TWO_FACTOR_AUTHENTICATION_ADDON_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_TWO_FACTOR_AUTHENTICATION_ADDON_SLUG', 'two-factor-authentication' );
define( 'MASTERIYO_TWO_FACTOR_AUTHENTICATION_ADDON_TEMPLATES', dirname( __FILE__ ) . '/templates' );

// Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_TWO_FACTOR_AUTHENTICATION_ADDON_SLUG ) ) {
	return;
}

require_once dirname( __FILE__ ) . '/helper/two-factor-authentication.php';

// Initiate two-factor authentication addon.
TwoFactorAuthenticationAddon::instance()->init();
