<?php

/**
 * OTP form template content.
 *
 * @version 2.7.0
 */

defined( 'ABSPATH' ) || exit;

$session = masteriyo( 'session' );
$user_id = $session->get( 'masteriyo_otp_login_user_id', 0 );
/**
 * Fires before rendering user OTP form.
 *
 * @since 2.7.0
 */
do_action( 'masteriyo_before_otp_form_content' );

?>
<section class="masteriyo-login-otp">
	<div class="masteriyo-login-otp--wrapper masteriyo-form-container">
		<h3 class="masteriyo-login-otp--title"><?php echo esc_html__( 'OTP verification', 'learning-management-system' ); ?></h3>

		<?php masteriyo_display_all_notices(); ?>

		<div id="masteriyo-login-otp-success-msg" class="masteriyo-notify-message masteriyo-alert masteriyo-success-msg">

		<?php

		/* translators: %s: email address */
		$translation_template = __( 'An OTP code has been sent to your registered email address (%s). To complete the login process, please enter the OTP code.', 'learning-management-system' );

		$localized_message = sprintf( $translation_template, masteriyo_get_user_email_by_id( $user_id ) );
		echo esc_html( $localized_message );
		?>
		</div>

		<form id="masteriyo-login-otp-form" class="masteriyo-login-otp-form" method="post">
			<input type="hidden" name="user_id" value="<?php echo esc_attr( $user_id ); ?>">
			<?php wp_nonce_field( 'masteriyo_login_otp_nonce' ); ?>
			<input type="hidden" name="redirect_to" value="<?php echo esc_url( masteriyo_get_current_url() ); ?>">
			<input type="hidden" name="resend_remaining_time" value="<?php echo esc_attr( masteriyo_get_resend_remaining_time( $user_id ) ); ?>">
			<input type="hidden" name="action" value="masteriyo_two_factor_authentication_otp_login">
			<input type="text" name="login-otp-code" id="masteriyo-login-otp-code" placeholder="<?php echo esc_attr__( 'Enter OTP code', 'learning-management-system' ); ?>">
			<div class="masteriyo-button-container">
				<button type="submit" name="masteriyo-otp-login" value="yes" class="masteriyo-btn-otp-login masteriyo-btn masteriyo-btn-primary"><?php echo esc_html__( 'Verify OTP', 'learning-management-system' ); ?></button>

				<button type="button" id="masteriyo-resend-login-otp" class="masteriyo-btn-otp-login-resend masteriyo-btn masteriyo-btn-secondary">
					<?php
						/* translators: %s: OTP remaining resend count. */
						$str = sprintf( __( 'Resend OTP (%s)', 'learning-management-system' ), masteriyo_get_resend_remaining_count( $user_id ) );
						echo esc_html( $str );
					?>
				</button>
			</div>
		</form>
		<span id="masteriyo-resend-counter" class="masteriyo-hidden masteriyo-resend-counter"><?php echo esc_html__( 'Remaining time to resend OTP: (0)', 'learning-management-system' ); ?></span>

		<div id="masteriyo-login-otp-error-msg" class="masteriyo-hidden masteriyo-notify-message masteriyo-alert masteriyo-danger-msg"></div>

	</div>
</section>
<?php

/**
 * Fires after rendering user OTP form.
 *
 * @since 2.7.0
 */
do_action( 'masteriyo_after_otp_form_content' );
