<?php
/**
 * White Label service provider.
 *
 * @since 2.2.9
 */

namespace Masteriyo\Addons\WhiteLabel\Providers;

defined( 'ABSPATH' ) || exit;

use Masteriyo\Addons\WhiteLabel\WhiteLabelAddon;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * WhiteLabel service provider.
 *
 * @since 2.2.9
 */
class WhiteLabelServiceProvider extends AbstractServiceProvider {
	/**
	 * The provided array is a way to let the container
	 * know that a service is provided by this service
	 * provider. Every service that is registered via
	 * this service provider must have an alias added
	 * to this array or it will be ignored
	 *
	 * @since 2.2.9
	 *
	 * @var array
	 */
	protected $provides = array(
		'addons.white-label',
		WhiteLabelAddon::class,
	);

	/**
	 * This is where the magic happens, within the method you can
	 * access the container and register or retrieve anything
	 * that you need to, but remember, every alias registered
	 * within this method must be declared in the `$provides` array.
	 *
	 * @since 2.2.9
	 */
	public function register() {
		$this->getContainer()->add( 'addons.white-label', WhiteLabelAddon::class, true );
	}
}
