<?php
/**
 * Store global white label options.
 *
 * @since 2.2.9
 * @package \Masteriyo\Addons\WhiteLabel
 */

class Setting {

	/**
	 * Global option name.
	 */
	const OPTION_NAME = 'masteriyo_white_label_settings';

	/**
	 * Data.
	 *
	 * @var array
	 */
	public $data = array(
		'title'         => 'Masteriyo',
		'logo'          => '',
		'active_icon'   => '',
		'inactive_icon' => '',
	);

	/**
	 * Return global white field value.
	 *
	 * @since 2.2.9
	 *
	 * @param string $key
	 * @return string
	 */
	public function get( $key ) {
		if ( isset( $this->data[ $key ] ) ) {
			return $this->data[ $key ];
		}

		return null;
	}

	/**
	 * Set global white label field.
	 *
	 * @since 2.2.9
	 *
	 * @param string $key Setting key.
	 * @param mixed $value Setting value.
	 */
	public function set( $key, $value ) {
		if ( isset( $this->data[ $key ] ) ) {
			$this->data[ $key ] = $value;
		}
	}

	public function exists( $key ) {

	}
}
