<?php
/**
 * Addon Name: White Label
 * Addon URI: https://masteriyo.com/wordpress-lms/
 * Description: Present Masteriyo as your own. You can hide the images & name of the plugin with this feature and use your brand name instead.
 * Author: Masteriyo
 * Author URI: https://masteriyo.com
 * Addon Type: enhancement
 * Plan: Starter
 */

use Masteriyo\Pro\Addons;

define( 'MASTERIYO_WHITE_LABEL_ADDON_FILE', __FILE__ );
define( 'MASTERIYO_WHITE_LABEL_ADDON_BASENAME', plugin_basename( __FILE__ ) );
define( 'MASTERIYO_WHITE_LABEL_ADDON_DIR', dirname( __FILE__ ) );
define( 'MASTERIYO_WHITE_LABEL_ASSETS', dirname( __FILE__ ) . '/assets' );
define( 'MASTERIYO_WHITE_LABEL_TEMPLATES', dirname( __FILE__ ) . '/templates' );
define( 'MASTERIYO_WHITE_LABEL_ADDON_SLUG', 'white-label' );

// Bail early if the addon is not active.
if ( ! ( new Addons() )->is_active( MASTERIYO_WHITE_LABEL_ADDON_SLUG ) ) {
	return;
}

/**
 * Include service providers for White Label.
 */
add_filter(
	'masteriyo_service_providers',
	function( $providers ) {
		return array_merge( $providers, require_once dirname( __FILE__ ) . '/config/providers.php' );
	}
);

/**
 * Initialize Masteriyo White Label.
 */
add_action(
	'masteriyo_before_init',
	function() {
		masteriyo( 'addons.white-label' )->init();
	}
);
